/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.lib.WandHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;

public abstract class PlaceholderItem
extends Item {
    public static PlaceholderItem capPlaceholder;
    public static PlaceholderItem rodPlaceholder;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] cachedIcons;
    private ItemStack[] baseItemCache;

    public static void registerPlaceholders() {
        if (SalisConfig.features.replaceWandCapsSettings.isEnabled()) {
            capPlaceholder = new WandCapPlaceholderItem();
            GameRegistry.registerItem((Item)capPlaceholder, (String)"capPlaceholder");
        }
        if (SalisConfig.features.replaceWandCoreSettings.isEnabled()) {
            rodPlaceholder = new WandRodPlaceholderItem();
            GameRegistry.registerItem((Item)rodPlaceholder, (String)"rodPlaceholder");
        }
    }

    public PlaceholderItem() {
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    private ItemStack[] baseItemCache() {
        if (this.baseItemCache == null) {
            this.baseItemCache = (ItemStack[])this.getBaseItems().filter(i -> i != null && i.func_77973_b() != null).toArray(ItemStack[]::new);
        }
        return this.baseItemCache;
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon[] cachedIcons() {
        if (this.cachedIcons == null) {
            this.cachedIcons = (IIcon[])Arrays.stream(this.baseItemCache()).map(itemStack -> {
                Item item;
                if (itemStack == null || (item = itemStack.func_77973_b()) == null) {
                    return null;
                }
                return item.func_77617_a(itemStack.func_77960_j());
            }).filter(Objects::nonNull).toArray(IIcon[]::new);
        }
        return this.cachedIcons;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        IIcon[] cachedIcons = this.cachedIcons();
        if (0 <= damage && damage < cachedIcons.length) {
            return cachedIcons[damage];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> outputList) {
        IIcon[] cachedIcons = this.cachedIcons();
        for (int index = 0; index < cachedIcons.length; ++index) {
            outputList.add(new ItemStack(item, 0, index));
        }
    }

    public String func_77667_c(ItemStack forItemStack) {
        int damage = forItemStack.func_77960_j();
        ItemStack[] cachedItems = this.baseItemCache();
        if (0 <= damage && damage < cachedItems.length) {
            return cachedItems[damage].func_77977_a();
        }
        return null;
    }

    protected abstract Stream<ItemStack> getBaseItems();

    public static class WandCapPlaceholderItem
    extends PlaceholderItem {
        @Override
        public Stream<ItemStack> getBaseItems() {
            return WandHelper.allVanillaCaps().stream().filter(Objects::nonNull).map(WandCap::getItem);
        }
    }

    public static class WandRodPlaceholderItem
    extends PlaceholderItem {
        @Override
        public Stream<ItemStack> getBaseItems() {
            return WandHelper.allVanillaRods().stream().filter(Objects::nonNull).map(WandRod::getItem);
        }
    }
}

