/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.tile.AEBaseInvTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import com.glodblock.github.inventory.AEFluidInventory;
import com.glodblock.github.inventory.IAEFluidInventory;
import com.glodblock.github.inventory.IAEFluidTank;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileIngredientBuffer
extends AEBaseInvTile
implements IAEFluidInventory,
IFluidHandler {
    protected AppEngInternalInventory invItems;
    protected AEFluidInventory invFluids = new AEFluidInventory((IAEFluidInventory)this, 4, 64000);

    public TileIngredientBuffer() {
        this.invItems = new AppEngInternalInventory((IAEAppEngInventory)this, 9);
    }

    @Nonnull
    public IInventory getInternalInventory() {
        return this.invItems;
    }

    public boolean canBeRotated() {
        return false;
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        this.markForUpdate();
    }

    public int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        this.saveChanges();
        this.markForUpdate();
    }

    @Override
    public AEFluidInventory getInternalFluid() {
        return this.invFluids;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    protected void writeToStream(ByteBuf data) throws IOException {
        for (int i = 0; i < this.invItems.func_70302_i_(); ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.invItems.func_70301_a(i));
        }
        this.invFluids.writeToBuf(data);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean changed = false;
        for (int i = 0; i < this.invItems.func_70302_i_(); ++i) {
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)data);
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.invItems.func_70301_a(i))) continue;
            this.invItems.func_70299_a(i, stack);
            changed = true;
        }
        return changed |= this.invFluids.readFromBuf(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        this.invItems.readFromNBT(data, "ItemInv");
        this.invFluids.readFromNBT(data, "FluidInv");
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public NBTTagCompound writeToNBTEvent(NBTTagCompound data) {
        this.invItems.writeToNBT(data, "ItemInv");
        this.invFluids.writeToNBT(data, "FluidInv");
        return data;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.invFluids.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.invFluids.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.invFluids.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.invFluids.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.invFluids.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.invFluids.getTankInfo(from);
    }
}

