/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.block;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridHost;
import appeng.util.Platform;
import com.glodblock.github.common.block.FCBaseBlock;
import com.glodblock.github.common.item.FCBaseItemBlock;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.common.tile.TileFluidAutoFiller;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.NameConst;
import com.glodblock.github.util.RenderUtil;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFluidAutoFiller
extends FCBaseBlock {
    public BlockFluidAutoFiller() {
        super(Material.field_151573_f, "fluid_auto_filler");
        this.setTileEntity(TileFluidAutoFiller.class);
        this.setFullBlock(false);
        this.setOpaque(false);
        this.field_149786_r = 3;
    }

    @Override
    public BlockFluidAutoFiller register() {
        GameRegistry.registerBlock((Block)this, FCBaseItemBlock.class, (String)"fluid_auto_filler");
        GameRegistry.registerTileEntity(TileFluidAutoFiller.class, (String)"fluid_auto_filler");
        this.func_149647_a(FluidCraftingTabs.INSTANCE);
        return this;
    }

    public boolean onActivated(World world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileFluidAutoFiller tile = (TileFluidAutoFiller)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile != null) {
            if (Platform.isServer()) {
                if (Util.hasPermission(player, SecurityPermissions.INJECT, (IGridHost)tile)) {
                    InventoryHandler.openGui(player, world, new BlockPos(x, y, z), ForgeDirection.getOrientation((int)facing), GuiType.FLUID_AUTO_FILLER);
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("You don't have permission to view."));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> toolTip, boolean advancedToolTips) {
        if (GuiScreen.func_146272_n()) {
            toolTip.addAll(RenderUtil.listFormattedStringToWidth(StatCollector.func_74838_a((String)"ae2fc.tooltip.fluid_auto_filler")));
        } else {
            toolTip.add(NameConst.i18n("ae2fc.tooltip.shift_for_more"));
        }
    }
}

