/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.util.MiscHelper;

public abstract class ITimerWarpEvent
extends IWarpEvent {
    protected final Function<World, Integer> incrementFunction;
    protected final ImmutableMap<String, String> timers;

    protected ITimerWarpEvent(String name, int minWarp, Function<World, Integer> incrementFunction, String ... timers) {
        super(name, minWarp);
        this.incrementFunction = incrementFunction;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String timer : timers) {
            builder.put((Object)timer, (Object)(name + "-" + timer));
        }
        this.timers = builder.build();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public abstract int triggerEvent(int var1, World var2, EntityPlayer var3);

    public void timerTick(World world, EntityPlayer player, String timer, int timerCount) {
    }

    public int getTimer(EntityPlayer player, String timer) {
        return MiscHelper.getWarpTag(player).func_74762_e((String)this.timers.get((Object)timer));
    }

    public void setTimer(EntityPlayer player, String timer, int timerCount) {
        MiscHelper.getWarpTag(player).func_74768_a((String)this.timers.get((Object)timer), timerCount);
    }

    public ImmutableMap<String, String> getTimers() {
        return this.timers;
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        this.sendChatMessage(player);
        MiscHelper.modEventInt(player, this.name, this.incrementFunction.apply(world));
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER) {
            return;
        }
        for (EntityPlayer player : e.world.field_73010_i) {
            boolean hasTimer = false;
            for (Map.Entry entry : this.timers.entrySet()) {
                if (!MiscHelper.getWarpTag(player).func_74764_b((String)entry.getValue())) continue;
                int count = this.decreaseTag(player, (String)entry.getValue(), 1);
                this.timerTick(e.world, player, (String)entry.getKey(), count);
                if (count <= 0) continue;
                hasTimer = true;
            }
            if (hasTimer || !MiscHelper.getWarpTag(player).func_74764_b(this.name)) continue;
            int eventAmount = MiscHelper.getWarpTag(player).func_74762_e(this.name);
            int decrement = this.triggerEvent(eventAmount, e.world, player);
            this.decreaseTag(player, this.name, decrement);
        }
    }
}

