/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.structure;

import com.gtnewhorizon.structurelib.structure.IStructureElement;
import gregtech.api.GregTechAPI;
import gregtech.api.casing.ICasing;
import gregtech.api.enums.Materials;
import gregtech.api.util.GTStructureUtility;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import org.jetbrains.annotations.NotNull;

public class CasingGTFrames
implements ICasing {
    public final Materials material;
    private static final Map<Materials, CasingGTFrames> FRAMES = new ConcurrentHashMap<Materials, CasingGTFrames>();

    private CasingGTFrames(Materials material) {
        this.material = material;
    }

    @NotNull
    public Block getBlock() {
        return GregTechAPI.sBlockFrames;
    }

    public int getBlockMeta() {
        return this.material.mMetaItemSubID;
    }

    public <T> IStructureElement<T> asElement(ICasing.CasingElementContext<T> context) {
        return GTStructureUtility.ofFrame((Materials)this.material);
    }

    public boolean isTiered() {
        return false;
    }

    public int getTextureId() {
        throw new UnsupportedOperationException("CasingGTFrames does not support getTextureId()");
    }

    public static CasingGTFrames forMaterial(Materials material) {
        return FRAMES.computeIfAbsent(material, CasingGTFrames::new);
    }
}

