/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building.providers;

import com.gtnewhorizon.gtnhlib.util.data.ImmutableItemMeta;
import com.gtnewhorizon.gtnhlib.util.data.ItemMeta;
import com.recursive_pineapple.matter_manipulator.common.building.IPseudoInventory;
import com.recursive_pineapple.matter_manipulator.common.building.providers.IItemProvider;
import com.recursive_pineapple.matter_manipulator.common.utils.BigItemStack;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.Nullable;

public class BatteryItemProvider
implements IItemProvider {
    public ImmutableItemMeta battery;

    public static BatteryItemProvider fromStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        boolean isBattery = false;
        for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)oreId).startsWith("battery")) continue;
            isBattery = true;
            break;
        }
        if (!isBattery) {
            return null;
        }
        BatteryItemProvider provider = new BatteryItemProvider();
        provider.battery = new ItemMeta(stack.func_77973_b(), Items.field_151008_G.getDamage(stack));
        return provider;
    }

    @Override
    @Nullable
    public ItemStack getStack(IPseudoInventory inv, boolean consume) {
        ItemStack stack = new ItemStack(this.battery.getItem(), 1, this.battery.getItemMeta());
        if (!consume) {
            return stack;
        }
        BooleanObjectImmutablePair<List<BigItemStack>> result = inv.tryConsumeItems(Arrays.asList(BigItemStack.create(stack)), 2);
        if (!result.leftBoolean()) {
            return null;
        }
        return ((BigItemStack)((List)result.right()).get(0)).getItemStack();
    }

    @Override
    public IItemProvider clone() {
        BatteryItemProvider provider = new BatteryItemProvider();
        provider.battery = new ItemMeta(this.battery.getItem(), this.battery.getItemMeta());
        return provider;
    }
}

