/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.networking.IGridHost;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AEColor;
import appeng.facade.FacadePart;
import appeng.helpers.ICustomNameObject;
import appeng.items.parts.ItemFacade;
import appeng.parts.automation.UpgradeInventory;
import appeng.parts.p2p.PartP2PTunnelNormal;
import appeng.tile.AEBaseTile;
import appeng.tile.networking.TileCableBus;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import com.google.gson.JsonElement;
import com.recursive_pineapple.matter_manipulator.common.building.AEPartData;
import com.recursive_pineapple.matter_manipulator.common.building.BlockAnalyzer;
import com.recursive_pineapple.matter_manipulator.common.building.ITileAnalysisIntegration;
import com.recursive_pineapple.matter_manipulator.common.building.InventoryAnalysis;
import com.recursive_pineapple.matter_manipulator.common.building.PortableItemStack;
import com.recursive_pineapple.matter_manipulator.common.building.providers.IItemProvider;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Transform;
import com.recursive_pineapple.matter_manipulator.common.utils.BigItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.ItemId;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AEAnalysisResult
implements ITileAnalysisIntegration {
    public AEColor mAEColour = null;
    public ForgeDirection mAEUp = null;
    public ForgeDirection mAEForward = null;
    public JsonElement mAEConfig = null;
    public PortableItemStack[] mAEUpgrades = null;
    public String mAECustomName = null;
    public AEPartData[] mAEParts = null;
    public PortableItemStack[] mAEFacades = null;
    public InventoryAnalysis mAECells = null;
    public InventoryAnalysis mAEPatterns = null;
    public static final ForgeDirection[] ALL_DIRECTIONS = ForgeDirection.values();
    private static final AEAnalysisResult NO_OP = new AEAnalysisResult();

    public static AEAnalysisResult analyze(TileEntity te) {
        if (te instanceof IGridHost) {
            AEAnalysisResult result = new AEAnalysisResult(te);
            return result.equals(NO_OP) ? null : result;
        }
        return null;
    }

    public AEAnalysisResult() {
    }

    public AEAnalysisResult(TileEntity te) {
        if (te instanceof AEBaseTile) {
            AEBaseTile ae = (AEBaseTile)te;
            this.mAEUp = MMUtils.nullIfUnknown(ae.getUp());
            this.mAEForward = MMUtils.nullIfUnknown(ae.getForward());
            this.mAEConfig = MMUtils.toJsonObject((NBTBase)ae.downloadSettings(SettingsFrom.MEMORY_CARD));
        }
        if (te instanceof IColorableTile) {
            IColorableTile colorable = (IColorableTile)te;
            this.mAEColour = colorable.getColor();
        }
        if (te instanceof ICustomNameObject) {
            ICustomNameObject customName = (ICustomNameObject)te;
            if (!(te instanceof TileCableBus)) {
                String string = this.mAECustomName = customName.hasCustomName() ? customName.getCustomName() : null;
            }
        }
        if (te instanceof ISegmentedInventory) {
            IInventory patterns;
            IInventory cells;
            ISegmentedInventory segmentedInventory = (ISegmentedInventory)te;
            IInventory iInventory = segmentedInventory.getInventoryByName("upgrades");
            if (iInventory instanceof UpgradeInventory) {
                UpgradeInventory upgrades = (UpgradeInventory)iInventory;
                this.mAEUpgrades = MMUtils.fromInventory((IInventory)upgrades);
            }
            if ((cells = segmentedInventory.getInventoryByName("cells")) != null) {
                this.mAECells = InventoryAnalysis.fromInventory(cells, false);
            }
            if ((patterns = segmentedInventory.getInventoryByName("patterns")) != null) {
                this.mAEPatterns = InventoryAnalysis.fromInventory(patterns, false);
            }
        }
        if (te instanceof IPartHost) {
            IPartHost partHost = (IPartHost)te;
            this.mAEParts = new AEPartData[ALL_DIRECTIONS.length];
            this.mAEFacades = new PortableItemStack[ForgeDirection.VALID_DIRECTIONS.length];
            boolean hasParts = false;
            boolean hasFacades = false;
            for (ForgeDirection dir : ALL_DIRECTIONS) {
                IPart part = partHost.getPart(dir);
                if (part == null) continue;
                this.mAEParts[dir.ordinal()] = new AEPartData(part);
                hasParts = true;
            }
            if (!hasParts) {
                this.mAEParts = null;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                IFacadePart facadePart = partHost.getFacadeContainer().getFacade(dir);
                if (facadePart == null) continue;
                this.mAEFacades[dir.ordinal()] = PortableItemStack.withNBT(facadePart.getItemStack());
                hasFacades = true;
            }
            if (!hasFacades) {
                this.mAEFacades = null;
            }
        }
    }

    @Override
    public boolean apply(BlockAnalyzer.IBlockApplyContext ctx) {
        IPartHost partHost;
        TileEntity te = ctx.getTileEntity();
        if (te instanceof IColorableTile) {
            IColorableTile colorable = (IColorableTile)te;
            if (this.mAEColour != null) {
                colorable.recolourBlock(ForgeDirection.NORTH, this.mAEColour, ctx.getRealPlayer());
            }
        }
        if (te instanceof ISegmentedInventory) {
            ISegmentedInventory segmentedInventory = (ISegmentedInventory)te;
            IInventory iInventory = segmentedInventory.getInventoryByName("upgrades");
            if (iInventory instanceof UpgradeInventory) {
                UpgradeInventory upgrades = (UpgradeInventory)iInventory;
                MMUtils.installUpgrades(ctx, upgrades, this.mAEUpgrades, true, false);
            }
            IInventory cells = segmentedInventory.getInventoryByName("cells");
            if (this.mAECells != null && cells != null) {
                this.mAECells.apply(ctx, cells, true, false);
            }
            IInventory patterns = segmentedInventory.getInventoryByName("patterns");
            if (this.mAEPatterns != null && patterns != null) {
                this.mAEPatterns.apply(ctx, patterns, true, false);
            }
        }
        if (te instanceof AEBaseTile) {
            AEBaseTile ae = (AEBaseTile)te;
            if (this.mAEUp != null && this.mAEForward != null) {
                ae.setOrientation(this.mAEForward, this.mAEUp);
            }
            if (this.mAEConfig != null) {
                ae.uploadSettings(SettingsFrom.MEMORY_CARD, (NBTTagCompound)MMUtils.toNbt(this.mAEConfig));
            }
        }
        if (this.mAECustomName != null && te instanceof ICustomNameObject) {
            ICustomNameObject customName = (ICustomNameObject)te;
            if (!(te instanceof TileCableBus)) {
                customName.setCustomName(this.mAECustomName);
            }
        }
        boolean success = true;
        if (te instanceof IPartHost) {
            partHost = (IPartHost)te;
            for (IInventory dir : ALL_DIRECTIONS) {
                boolean isAttunable;
                IPart part = partHost.getPart((ForgeDirection)dir);
                AEPartData expected = MMUtils.getIndexSafe(this.mAEParts, dir.ordinal());
                ItemId actualItem = part == null ? null : ItemId.createWithoutNBT(part.getItemStack(PartItemStack.Break));
                ItemStack expectedStack = expected == null ? null : expected.getEffectivePartStack();
                ItemId expectedItem = expectedStack == null ? null : ItemId.createWithoutNBT(expectedStack);
                boolean bl = isAttunable = part instanceof PartP2PTunnelNormal && expected != null && expected.isAttunable();
                if (!isAttunable) {
                    if (!(actualItem == null || expectedItem != null && Objects.equals(actualItem, expectedItem))) {
                        BooleanObjectImmutablePair<List<BigItemStack>> result;
                        if (expectedStack != null && !(result = ctx.tryConsumeItems(Arrays.asList(BigItemStack.create(expectedStack)), 1)).leftBoolean()) {
                            ctx.warn("Could not extract item: " + expectedStack.func_82833_r());
                            continue;
                        }
                        this.removePart(ctx, partHost, (ForgeDirection)dir, false);
                        actualItem = null;
                    }
                    if (actualItem == null && expectedItem != null) {
                        if (expectedStack != null && !partHost.canAddPart(expectedStack, (ForgeDirection)dir)) {
                            ctx.error("Invalid location (" + MMUtils.getDirectionDisplayName((ForgeDirection)dir, true) + ") for part (" + expectedStack.func_82833_r() + ")");
                            continue;
                        }
                        if (!this.installPart(ctx, partHost, (ForgeDirection)dir, expected, false)) {
                            success = false;
                            continue;
                        }
                    }
                }
                if (expected != null && !expected.updatePart(ctx, partHost, (ForgeDirection)dir)) {
                    success = false;
                    continue;
                }
                Platform.notifyBlocksOfNeighbors((World)te.func_145831_w(), (int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e);
            }
        }
        if (te instanceof IPartHost) {
            partHost = (IPartHost)te;
            IFacadeContainer facadeContainer = partHost.getFacadeContainer();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                ItemFacade itemFacade;
                FacadePart newPart;
                Item item;
                ItemId expectedItem;
                IFacadePart actual = facadeContainer.getFacade(dir);
                PortableItemStack expected = MMUtils.getIndexSafe(this.mAEFacades, dir.ordinal());
                ItemStack existingStack = actual == null ? null : actual.getItemStack();
                ItemId actualItem = actual == null ? null : ItemId.create(existingStack);
                ItemStack expectedStack = expected == null ? null : expected.toStack();
                ItemId itemId = expectedItem = expectedStack == null ? null : ItemId.create(expectedStack);
                if (!(actualItem == null || expectedItem != null && Objects.equals(actualItem, expectedItem))) {
                    BooleanObjectImmutablePair<List<BigItemStack>> result;
                    if (expectedStack != null && !(result = ctx.tryConsumeItems(Arrays.asList(BigItemStack.create(expectedStack)), 1)).leftBoolean()) {
                        ctx.warn("Could not extract item: " + expectedStack.func_82833_r());
                        continue;
                    }
                    ctx.givePlayerItems(existingStack);
                    facadeContainer.removeFacade(partHost, dir);
                    actualItem = null;
                }
                if (actualItem != null || expectedItem == null || !((item = expectedStack.func_77973_b()) instanceof ItemFacade) || (newPart = (itemFacade = (ItemFacade)item).createPartFromItemStack(expectedStack, dir)) == null) continue;
                if (!ctx.tryConsumeItems(expectedStack)) {
                    ctx.warn("Could not extract item: " + expectedStack.func_82833_r());
                    continue;
                }
                facadeContainer.addFacade((IFacadePart)newPart);
            }
        }
        return success;
    }

    private void removePart(BlockAnalyzer.IBlockApplyContext context, IPartHost partHost, ForgeDirection side, boolean simulate) {
        IPart part = partHost.getPart(side);
        if (part == null) {
            return;
        }
        ArrayList drops = new ArrayList();
        part.getDrops(drops, false);
        context.givePlayerItems((ItemStack[])drops.stream().map(ItemStack::func_77946_l).toArray(ItemStack[]::new));
        ItemStack partStack = part.getItemStack(PartItemStack.Break).func_77946_l();
        NBTTagCompound tag = partStack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o("display");
            if (tag.func_82582_d()) {
                partStack.func_77982_d(null);
            }
        }
        context.givePlayerItems(partStack);
        if (!simulate) {
            partHost.removePart(side, false);
        }
    }

    private boolean installPart(BlockAnalyzer.IBlockApplyContext context, IPartHost partHost, ForgeDirection side, AEPartData partData, boolean simulate) {
        ItemStack partStack = partData.getEffectivePartStack();
        if (!partHost.canAddPart(partStack, side)) {
            return false;
        }
        if (!context.tryConsumeItems(partStack)) {
            context.warn("Could not find " + partStack.func_82833_r());
            return false;
        }
        if (!simulate && partHost.addPart(partStack, side, context.getRealPlayer()) == null) {
            context.givePlayerItems(partStack);
            return false;
        }
        return true;
    }

    @Override
    public boolean getRequiredItemsForExistingBlock(BlockAnalyzer.IBlockApplyContext context) {
        TileEntity te = context.getTileEntity();
        if (te instanceof ISegmentedInventory) {
            IInventory iInventory;
            ISegmentedInventory segmentedInventory = (ISegmentedInventory)te;
            if (this.mAEUpgrades != null && (iInventory = segmentedInventory.getInventoryByName("upgrades")) instanceof UpgradeInventory) {
                UpgradeInventory upgrades = (UpgradeInventory)iInventory;
                MMUtils.installUpgrades(context, upgrades, this.mAEUpgrades, true, true);
            }
            IInventory cells = segmentedInventory.getInventoryByName("cells");
            if (this.mAECells != null && cells != null) {
                this.mAECells.apply(context, cells, true, true);
            }
        }
        if (this.mAEParts != null && te instanceof IPartHost) {
            IPartHost partHost = (IPartHost)te;
            for (ForgeDirection dir : ALL_DIRECTIONS) {
                boolean isAttunable;
                IPart part = partHost.getPart(dir);
                AEPartData expected = this.mAEParts[dir.ordinal()];
                ItemId actualItem = part == null ? null : ItemId.createWithoutNBT(part.getItemStack(PartItemStack.Break));
                ItemId expectedItem = expected == null ? null : ItemId.createWithoutNBT(expected.getEffectivePartStack());
                boolean bl = isAttunable = part instanceof PartP2PTunnelNormal && expected != null && expected.isAttunable();
                if (!isAttunable) {
                    if (!(expectedItem != null && Objects.equals(actualItem, expectedItem) || actualItem == null)) {
                        this.removePart(context, partHost, dir, true);
                        actualItem = null;
                    }
                    if (actualItem == null && expectedItem != null && !this.installPart(context, partHost, dir, expected, true)) {
                        return false;
                    }
                }
                if (expected != null && !expected.getRequiredItemsForExistingPart(context, partHost, dir)) {
                    return false;
                }
                Platform.notifyBlocksOfNeighbors((World)te.func_145831_w(), (int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e);
            }
        }
        return true;
    }

    @Override
    public boolean getRequiredItemsForNewBlock(BlockAnalyzer.IBlockApplyContext context) {
        if (this.mAEUpgrades != null) {
            for (IItemProvider iItemProvider : this.mAEUpgrades) {
                context.tryConsumeItems(((PortableItemStack)iItemProvider).toStack());
            }
        }
        if (this.mAECells != null) {
            for (IItemProvider iItemProvider : this.mAECells.mItems) {
                if (iItemProvider == null) continue;
                iItemProvider.getStack(context, true);
            }
        }
        if (this.mAEParts != null) {
            for (IItemProvider iItemProvider : ALL_DIRECTIONS) {
                AEPartData expected = this.mAEParts[iItemProvider.ordinal()];
                if (expected == null) continue;
                context.tryConsumeItems(expected.getEffectivePartStack());
                if (expected.getRequiredItemsForNewPart(context)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void getItemTag(NBTTagCompound tag) {
    }

    @Override
    public void getItemDetails(List<String> details) {
    }

    @Override
    public void transform(Transform transform) {
        this.mAEUp = transform.apply(this.mAEUp);
        this.mAEForward = transform.apply(this.mAEForward);
        if (this.mAEParts != null) {
            AEPartData[] partsOut = new AEPartData[ALL_DIRECTIONS.length];
            int unknown = ForgeDirection.UNKNOWN.ordinal();
            for (int i = 0; i < partsOut.length; ++i) {
                if (i == unknown) {
                    partsOut[unknown] = this.mAEParts[unknown];
                    continue;
                }
                partsOut[transform.apply((ForgeDirection)AEAnalysisResult.ALL_DIRECTIONS[i]).ordinal()] = this.mAEParts[i];
            }
            this.mAEParts = partsOut;
        }
    }

    @Override
    public void migrate() {
    }

    @Override
    public AEAnalysisResult clone() {
        AEAnalysisResult dup = new AEAnalysisResult();
        dup.mAEColour = this.mAEColour;
        dup.mAEUp = this.mAEUp;
        dup.mAEForward = this.mAEForward;
        dup.mAEConfig = this.mAEConfig == null ? null : MMUtils.toJsonObject(MMUtils.toNbt(this.mAEConfig));
        dup.mAEUpgrades = this.mAEUpgrades == null ? null : MMUtils.mapToArray(this.mAEUpgrades, PortableItemStack[]::new, x -> x == null ? null : x.clone());
        dup.mAECustomName = this.mAECustomName;
        dup.mAEParts = this.mAEParts == null ? null : MMUtils.mapToArray(this.mAEParts, AEPartData[]::new, x -> x == null ? null : x.clone());
        dup.mAECells = this.mAECells == null ? null : this.mAECells.clone();
        dup.mAEPatterns = this.mAEPatterns == null ? null : this.mAEPatterns.clone();
        return dup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mAEColour == null ? 0 : this.mAEColour.hashCode());
        result = 31 * result + (this.mAEUp == null ? 0 : this.mAEUp.hashCode());
        result = 31 * result + (this.mAEForward == null ? 0 : this.mAEForward.hashCode());
        result = 31 * result + (this.mAEConfig == null ? 0 : this.mAEConfig.hashCode());
        result = 31 * result + Arrays.hashCode(this.mAEUpgrades);
        result = 31 * result + (this.mAECustomName == null ? 0 : this.mAECustomName.hashCode());
        result = 31 * result + Arrays.hashCode(this.mAEParts);
        result = 31 * result + (this.mAECells == null ? 0 : this.mAECells.hashCode());
        result = 31 * result + (this.mAEPatterns == null ? 0 : this.mAEPatterns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AEAnalysisResult other = (AEAnalysisResult)obj;
        if (this.mAEColour != other.mAEColour) {
            return false;
        }
        if (this.mAEUp != other.mAEUp) {
            return false;
        }
        if (this.mAEForward != other.mAEForward) {
            return false;
        }
        if (this.mAEConfig == null ? other.mAEConfig != null : !this.mAEConfig.equals(other.mAEConfig)) {
            return false;
        }
        if (!Arrays.equals(this.mAEUpgrades, other.mAEUpgrades)) {
            return false;
        }
        if (this.mAECustomName == null ? other.mAECustomName != null : !this.mAECustomName.equals(other.mAECustomName)) {
            return false;
        }
        if (!Arrays.equals(this.mAEParts, other.mAEParts)) {
            return false;
        }
        if (this.mAECells == null ? other.mAECells != null : !this.mAECells.equals(other.mAECells)) {
            return false;
        }
        return !(this.mAEPatterns == null ? other.mAEPatterns != null : !this.mAEPatterns.equals(other.mAEPatterns));
    }
}

