/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import gnu.trove.set.hash.TIntHashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.IAudioConnection;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.audio.AudioUtils;
import pl.asie.lib.block.TileEntityBase;
import pl.asie.lib.util.ColorUtils;
import pl.asie.lib.util.internal.IColorable;

public class TileAudioCable
extends TileEntityBase
implements IAudioReceiver,
IColorable {
    private final TIntHashSet packetIds = new TIntHashSet();
    private int ImmibisMicroblocks_TransformableTileEntityMarker;
    private int connectionMap = 0;
    private boolean initialConnect = false;
    protected int overlayColor = this.getDefaultColor();

    private void updateConnections() {
        this.connectionMap = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile;
            if (!this.connectsInternal(dir) || !this.field_145850_b.func_72899_e(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) || (!((tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) instanceof TileAudioCable) ? !(tile instanceof IAudioConnection) || !((IAudioConnection)tile).connectsAudio(dir.getOpposite()) : !((TileAudioCable)tile).connectsInternal(dir.getOpposite()))) continue;
            if (tile instanceof IColorable && ((IColorable)tile).canBeColored() && !ColorUtils.isSameOrDefault((IColorable)this, (IColorable)((IColorable)tile))) continue;
            this.connectionMap |= 1 << dir.ordinal();
        }
    }

    protected boolean connectsInternal(ForgeDirection dir) {
        return this.ImmibisMicroblocks_isSideOpen(dir.ordinal());
    }

    @Override
    public boolean connectsAudio(ForgeDirection dir) {
        if (!this.initialConnect) {
            this.updateConnections();
            this.initialConnect = true;
        }
        return (this.connectionMap >> dir.ordinal() & 1) == 1;
    }

    public void func_145845_h() {
        this.packetIds.clear();
        this.updateConnections();
    }

    @Override
    public void receivePacket(AudioPacket packet, ForgeDirection side) {
        if (this.packetIds.contains(packet.id)) {
            return;
        }
        this.packetIds.add(packet.id);
        for (int i = 0; i < 6; ++i) {
            TileEntity tile;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (dir == side || !this.connectsAudio(dir) || !this.field_145850_b.func_72899_e(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) || !((tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) instanceof IAudioReceiver)) continue;
            ((IAudioReceiver)tile).receivePacket(packet, dir.getOpposite());
        }
    }

    @Override
    public String getID() {
        return AudioUtils.positionId(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public World getSoundWorld() {
        return null;
    }

    @Override
    public Vec3 getSoundPos() {
        return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    @Override
    public int getSoundDistance() {
        return 0;
    }

    public boolean canBeColored() {
        return true;
    }

    public int getColor() {
        return this.overlayColor;
    }

    public int getDefaultColor() {
        return ColorUtils.Color.LightGray.color;
    }

    public void setColor(int color) {
        this.overlayColor = color;
        this.func_70296_d();
    }

    public void readFromRemoteNBT(NBTTagCompound nbt) {
        super.readFromRemoteNBT(nbt);
        int oldColor = this.overlayColor;
        if (nbt.func_74764_b("computronics:color")) {
            this.overlayColor = nbt.func_74762_e("computronics:color");
        }
        if (this.overlayColor < 0) {
            this.overlayColor = this.getDefaultColor();
        }
        if (oldColor != this.overlayColor) {
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void writeToRemoteNBT(NBTTagCompound nbt) {
        super.writeToRemoteNBT(nbt);
        if (this.overlayColor != this.getDefaultColor()) {
            nbt.func_74768_a("computronics:color", this.overlayColor);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("computronics:color")) {
            this.overlayColor = nbt.func_74762_e("computronics:color");
        }
        if (this.overlayColor < 0) {
            this.overlayColor = this.getDefaultColor();
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.overlayColor != this.getDefaultColor()) {
            nbt.func_74768_a("computronics:color", this.overlayColor);
        }
    }

    public boolean ImmibisMicroblocks_isSideOpen(int side) {
        return true;
    }

    public void ImmibisMicroblocks_onMicroblocksChanged() {
    }
}

