/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.land;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenerator;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoShrub;
import rwg.deco.trees.DecoSmallPine;
import rwg.deco.trees.DecoSmallSpruce;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceTundra;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainFlatLakes;
import rwg.util.CellNoise;
import rwg.util.NoiseGenerator;

public class RealisticBiomeTundraPlains
extends RealisticBiomeBase {
    private TerrainBase terrain = new TerrainFlatLakes();
    private SurfaceBase surface = new SurfaceTundra((Block)Blocks.field_150349_c, Blocks.field_150346_d);

    public RealisticBiomeTundraPlains() {
        super(0, RWGBiomes.baseColdPlains, RealisticBiomeBase.coastDunes, RWGBiomes.baseRiverCold);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, NoiseGenerator perlin, CellNoise cell, float strength, float river) {
        int j1;
        int i1;
        int k1;
        int i8;
        int i2;
        int l4;
        if (rand.nextInt((int)(15.0f / strength)) == 0 && (l4 = world.func_72976_f(i2 = chunkX + rand.nextInt(16) + 8, i8 = chunkY + rand.nextInt(16) + 8)) > 63 && l4 < 105) {
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(world, rand, i2, l4, i8);
        }
        int l = 0;
        while ((float)l < 3.0f * strength) {
            int j12;
            int i12 = chunkX + rand.nextInt(16) + 8;
            int k12 = world.func_72976_f(i12, j12 = chunkY + rand.nextInt(16) + 8);
            if (k12 < 85 && (k12 < 64 || rand.nextInt(5) == 0)) {
                new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i12, k12, j12);
            }
            ++l;
        }
        if (rand.nextInt((int)(2.0f / strength)) == 0) {
            int j6 = chunkX + rand.nextInt(16) + 8;
            int k10 = chunkY + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10);
            WorldGenerator worldgenerator = rand.nextInt(7) == 0 ? new DecoSmallSpruce(0 + rand.nextInt(2)) : new DecoSmallPine(2 + rand.nextInt(3), 4 + rand.nextInt(4), rand.nextInt(2));
            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator.func_76484_a(world, rand, j6, z52, k10);
        }
        if (rand.nextInt((int)(1.0f / strength)) == 0 && (k1 = world.func_72976_f(i1 = chunkX + rand.nextInt(16) + 8, j1 = chunkY + rand.nextInt(16) + 8)) < 90) {
            new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
        }
        if (rand.nextInt((int)(25.0f / strength)) == 0) {
            int j16 = chunkX + rand.nextInt(16) + 8;
            int j18 = rand.nextInt(100);
            int j21 = chunkY + rand.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
        }
        int f23 = 0;
        while ((float)f23 < 2.0f * strength) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new DecoFlowers(new int[]{0}).func_76484_a(world, rand, j15, j17, j20);
            ++f23;
        }
        int l14 = 0;
        while ((float)l14 < 4.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }

    @Override
    public float rNoise(NoiseGenerator perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, NoiseGenerator perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

