/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.api.farming.IFarmableBasic;
import forestry.api.genetics.IFruitBearer;
import forestry.core.utils.vect.IVect;
import forestry.core.utils.vect.MutableVect;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.logic.CropFruit;
import forestry.farming.logic.FarmLogic;
import forestry.farming.logic.FarmableReference;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class FarmLogicOrchard
extends FarmLogic {
    protected Collection<IFarmable> farmables;
    protected final HashMap<Vect, Integer> lastExtents = new HashMap();
    protected final ImmutableList<Block> traversalBlocks;
    protected boolean precalcBlockType;
    protected boolean precalcBlockMeta;

    public FarmLogicOrchard(IFarmHousing housing) {
        super(housing);
        Block grapeVine;
        this.setFarmables(Farmables.farmables.get(FarmableReference.Orchard.get()));
        ImmutableList.Builder traversalBlocksBuilder = ImmutableList.builder();
        if (PluginManager.Module.AGRICRAFT.isEnabled() || PluginManager.Module.INDUSTRIALCRAFT.isEnabled()) {
            traversalBlocksBuilder.add((Object)Blocks.field_150458_ak);
        }
        if (PluginManager.Module.INDUSTRIALCRAFT.isEnabled()) {
            traversalBlocksBuilder.add((Object)Blocks.field_150346_d);
        }
        if (PluginManager.Module.PLANTMEGAPACK.isEnabled()) {
            traversalBlocksBuilder.add((Object)Blocks.field_150355_j);
        }
        if ((grapeVine = GameRegistry.findBlock((String)"Growthcraft|Grapes", (String)"grc.grapeVine1")) != null) {
            traversalBlocksBuilder.add((Object)grapeVine);
        }
        traversalBlocksBuilder.build();
        this.traversalBlocks = traversalBlocksBuilder.build();
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(40.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x, int y, int z, FarmDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        int lastExtent;
        Vect start = new Vect(x, y, z);
        if (!this.lastExtents.containsKey(start)) {
            this.lastExtents.put(start, 0);
        }
        if ((lastExtent = this.lastExtents.get(start).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x, y + 1, z, direction, lastExtent);
        Collection<ICrop> crops = this.getHarvestBlocks(position);
        this.lastExtents.put(start, ++lastExtent);
        return crops;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return PluginCore.items.fruits.func_77617_a(0);
    }

    @Override
    public String getName() {
        return "Orchard";
    }

    private Collection<ICrop> getHarvestBlocks(Vect position) {
        HashSet<Vect> seen = new HashSet<Vect>();
        ArrayDeque<ICrop> crops = new ArrayDeque<ICrop>();
        World world = this.getWorld();
        if (!(VectUtil.isWoodBlock(world, position) || FarmLogicOrchard.isBlockTraversable(world, position, this.traversalBlocks) || this.isFruitBearer(world, position))) {
            return crops;
        }
        List<Vect> candidates = this.processHarvestBlock(crops, seen, position, position);
        ArrayList<Vect> temp = new ArrayList<Vect>();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (int i = 0; i < candidates.size(); ++i) {
                temp.addAll(this.processHarvestBlock(crops, seen, position, candidates.get(i)));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private List<Vect> processHarvestBlock(Deque<ICrop> crops, Set<Vect> seen, IVect start, IVect position) {
        World world = this.getWorld();
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        MutableVect mutable = new MutableVect();
        for (int i = -2; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    Vect immutable;
                    mutable.set(position).add(i, j, k);
                    if (Math.abs(mutable.getX() - start.getX()) > 5 || Math.abs(mutable.getZ() - start.getZ()) > 5 || seen.contains(mutable) || VectUtil.isAirBlock(world, mutable)) continue;
                    if (VectUtil.isWoodBlock(world, mutable) || FarmLogicOrchard.isBlockTraversable(world, mutable, this.traversalBlocks)) {
                        immutable = new Vect(mutable);
                        candidates.add(immutable);
                        seen.add(immutable);
                        continue;
                    }
                    if (!this.isFruitBearer(world, mutable)) continue;
                    immutable = new Vect(mutable);
                    candidates.add(immutable);
                    seen.add(immutable);
                    ICrop crop = this.getCrop(world, immutable);
                    if (crop == null) continue;
                    crops.push(crop);
                }
            }
        }
        return candidates;
    }

    private boolean isFruitBearer(World world, IVect position) {
        TileEntity tile = world.func_147438_o(position.getX(), position.getY(), position.getZ());
        if (tile instanceof IFruitBearer) {
            return true;
        }
        Block block = this.precalcBlockType ? world.func_147439_a(position.getX(), position.getY(), position.getZ()) : null;
        int meta = this.precalcBlockMeta ? world.func_72805_g(position.getX(), position.getY(), position.getZ()) : -1;
        for (IFarmable farmable : this.farmables) {
            if (!(farmable instanceof IFarmableBasic ? ((IFarmableBasic)farmable).isSapling(block, meta) : farmable.isSaplingAt(world, position.getX(), position.getY(), position.getZ()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isBlockTraversable(World world, IVect position, ImmutableList<Block> traversalBlocks) {
        Block candidate = VectUtil.getBlock(world, position);
        for (int i = 0; i < traversalBlocks.size(); ++i) {
            if (candidate != traversalBlocks.get(i)) continue;
            return true;
        }
        return false;
    }

    private ICrop getCrop(World world, IVect position) {
        TileEntity tile = world.func_147438_o(position.getX(), position.getY(), position.getZ());
        if (tile instanceof IFruitBearer) {
            IFruitBearer fruitBearer = (IFruitBearer)tile;
            if (fruitBearer.hasFruit() && fruitBearer.getRipeness() >= 0.9f) {
                return new CropFruit(world, position.asImmutable());
            }
        } else {
            for (IFarmable seed : this.farmables) {
                ICrop crop = seed.getCropAt(world, position.getX(), position.getY(), position.getZ());
                if (crop == null) continue;
                return crop;
            }
        }
        return null;
    }

    protected void setFarmables(Collection<IFarmable> farmables) {
        this.farmables = farmables;
        for (IFarmable farmable : farmables) {
            if (!(farmable instanceof IFarmableBasic)) continue;
            this.precalcBlockType = true;
            if (!((IFarmableBasic)farmable).isMetadataAware()) continue;
            this.precalcBlockMeta = true;
            return;
        }
    }
}

