/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.genetics.IFruitBearer;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.vect.IVect;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.Crop;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CropFruit
extends Crop {
    public CropFruit(World world, Vect position) {
        super(world, position);
    }

    @Override
    protected boolean isCrop(IVect pos) {
        TileEntity tile = this.world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
        if (!(tile instanceof IFruitBearer)) {
            return false;
        }
        IFruitBearer bearer = (IFruitBearer)tile;
        if (!bearer.hasFruit()) {
            return false;
        }
        return !(bearer.getRipeness() < 0.9f);
    }

    @Override
    protected Collection<ItemStack> harvestBlock(IVect pos) {
        TileEntity tile = this.world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
        if (!(tile instanceof IFruitBearer)) {
            return new ArrayList<ItemStack>();
        }
        Proxies.common.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.LEAF, this.world, pos.getX(), pos.getY(), pos.getZ(), this.world.func_147439_a(pos.getX(), pos.getY(), pos.getZ()), 0);
        return ((IFruitBearer)tile).pickFruit(null);
    }
}

