/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import cpw.mods.fml.common.registry.EntityRegistry;
import forestry.api.core.ForestryAPI;
import forestry.core.entities.EntitySelector;
import forestry.core.utils.Log;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityUtil {
    public static <E extends EntityLiving> E spawnEntity(World world, Class<E> entityClass, double x, double y, double z) {
        E entityLiving = EntityUtil.createEntity(world, entityClass);
        if (entityLiving == null) {
            return null;
        }
        return EntityUtil.spawnEntity(world, entityLiving, x, y, z);
    }

    public static <E extends EntityLiving> E spawnEntity(World world, E living, double x, double y, double z) {
        if (living == null) {
            return null;
        }
        living.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        living.field_70759_as = living.field_70177_z;
        living.field_70761_aq = living.field_70177_z;
        living.func_110161_a(null);
        world.func_72838_d(living);
        living.func_70642_aH();
        return living;
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String ident, int id, int eggForeground, int eggBackground, int trackingRange, int updateFrequency, boolean sendVelocity) {
        EntityRegistry.registerModEntity(entityClass, (String)ident, (int)id, (Object)ForestryAPI.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocity);
        Log.finer("Registered entity %s (%s) with id %s.", ident, entityClass.toString(), id);
    }

    public static <T extends Entity> List<T> getEntitiesWithinAABB(World world, Class<T> entityClass, AxisAlignedBB boundingBox) {
        return world.func_72872_a(entityClass, boundingBox);
    }

    public static <T extends Entity> List<T> selectEntitiesWithinAABB(World world, EntitySelector<T> entitySelector, AxisAlignedBB boundingBox) {
        return world.func_82733_a(entitySelector.getEntityClass(), boundingBox, entitySelector);
    }

    private static <E extends EntityLiving> E createEntity(World world, Class<E> entityClass) {
        if (!EntityList.field_75626_c.containsKey(entityClass)) {
            return null;
        }
        String entityString = (String)EntityList.field_75626_c.get(entityClass);
        if (entityString == null) {
            return null;
        }
        Entity entity = EntityList.func_75620_a((String)entityString, (World)world);
        return (E)((EntityLiving)entityClass.cast(entity));
    }
}

