/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import cpw.mods.fml.common.registry.GameData;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;

public class PacketFXSignal
extends PacketCoordinates
implements IForestryPacketClient {
    private VisualFXType visualFX;
    private SoundFXType soundFX;
    private Block block;
    private int meta;

    public PacketFXSignal() {
    }

    public PacketFXSignal(VisualFXType type, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        this(type, SoundFXType.NONE, xCoord, yCoord, zCoord, block, meta);
    }

    public PacketFXSignal(SoundFXType type, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        this(VisualFXType.NONE, type, xCoord, yCoord, zCoord, block, meta);
    }

    public PacketFXSignal(VisualFXType visualFX, SoundFXType soundFX, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        super(xCoord, yCoord, zCoord);
        this.visualFX = visualFX;
        this.soundFX = soundFX;
        this.block = block;
        this.meta = meta;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeShort(this.visualFX.ordinal());
        data.writeShort(this.soundFX.ordinal());
        data.writeUTF(GameData.getBlockRegistry().func_148750_c((Object)this.block));
        data.writeInt(this.meta);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.visualFX = VisualFXType.values()[data.readShort()];
        this.soundFX = SoundFXType.values()[data.readShort()];
        this.block = (Block)GameData.getBlockRegistry().getRaw(data.readUTF());
        this.meta = data.readInt();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        if (this.visualFX != VisualFXType.NONE) {
            Proxies.common.addBlockDestroyEffects(Proxies.common.getRenderWorld(), this.getPosX(), this.getPosY(), this.getPosZ(), this.block, this.meta);
        }
        if (this.soundFX != SoundFXType.NONE) {
            if (this.soundFX == SoundFXType.BLOCK_DESTROY) {
                Proxies.common.playBlockBreakSoundFX(Proxies.common.getRenderWorld(), this.getPosX(), this.getPosY(), this.getPosZ(), this.block);
            } else if (this.soundFX == SoundFXType.BLOCK_PLACE) {
                Proxies.common.playBlockPlaceSoundFX(Proxies.common.getRenderWorld(), this.getPosX(), this.getPosY(), this.getPosZ(), this.block);
            } else {
                Proxies.common.playSoundFX(Proxies.common.getRenderWorld(), this.getPosX(), this.getPosY(), this.getPosZ(), this.soundFX.soundFile, this.soundFX.volume, this.soundFX.pitch);
            }
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.FX_SIGNAL;
    }

    public static enum SoundFXType {
        NONE(""),
        BLOCK_DESTROY(""),
        BLOCK_PLACE(""),
        LEAF("step.grass"),
        LOG("dig.wood"),
        DIRT("dig.gravel");

        public final String soundFile;
        public final float volume;
        public final float pitch;

        private SoundFXType(String soundFile) {
            this.soundFile = soundFile;
            this.volume = 1.0f;
            this.pitch = 1.0f;
        }
    }

    public static enum VisualFXType {
        NONE,
        BLOCK_DESTROY,
        SAPLING_PLACE;

    }
}

