/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.botanicaladdons.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import ninja.shadowfox.shadowfox_botany.api.ShadowFoxAPI;
import ninja.shadowfox.shadowfox_botany.api.recipe.RecipeTreeCrafting;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.botanicaladdons.DendricSuffuser")
public class DendricSuffuser {
    protected static final String name = "Botanical Addons Dendric Suffuser";

    @ZenMethod
    public static void addRecipe(IItemStack blockOutput, int mana, int throttle, IIngredient[] input) {
        Object output = InputHelper.toObject((IIngredient)blockOutput);
        if (output == null || !(output instanceof ItemStack) || !InputHelper.isABlock((ItemStack)output)) {
            LogHelper.logError("Output must be a block.");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipeTreeCrafting(mana, Block.func_149634_a((Item)((ItemStack)output).func_77973_b()), ((ItemStack)output).func_77960_j(), throttle, InputHelper.toObjects(input))));
    }

    @ZenMethod
    public static void addRecipe(IItemStack blockOutput, int mana, IIngredient[] input) {
        DendricSuffuser.addRecipe(blockOutput, mana, -1, input);
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        LinkedList<RecipeTreeCrafting> recipes = new LinkedList<RecipeTreeCrafting>();
        for (RecipeTreeCrafting r : ShadowFoxAPI.treeRecipes) {
            if (r == null || r.getOutput() == null || !StackHelper.matches((IIngredient)output, InputHelper.toIItemStack(r.getOutput()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<RecipeTreeCrafting> {
        public Remove(List<RecipeTreeCrafting> recipes) {
            super(DendricSuffuser.name, ShadowFoxAPI.treeRecipes, recipes);
        }

        @Override
        public String getRecipeInfo(RecipeTreeCrafting recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    private static class Add
    extends BaseListAddition<RecipeTreeCrafting> {
        public Add(RecipeTreeCrafting recipe) {
            super(DendricSuffuser.name, ShadowFoxAPI.treeRecipes);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(RecipeTreeCrafting recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }
}

