/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.network.msg;

import com.dreammaster.main.MainRegistry;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;

public class CTTClientSyncMessage
implements IMessage {
    protected String _mPayload;
    protected int _mFrame;
    protected int _mNumFrames;

    public CTTClientSyncMessage() {
    }

    public CTTClientSyncMessage(String pPayload, int pFrame, int pNumFrames) {
        this._mPayload = pPayload;
        this._mFrame = pFrame;
        this._mNumFrames = pNumFrames;
    }

    public void fromBytes(ByteBuf pBuffer) {
        this._mFrame = pBuffer.readInt();
        this._mNumFrames = pBuffer.readInt();
        this._mPayload = ByteBufUtils.readUTF8String((ByteBuf)pBuffer);
    }

    public void toBytes(ByteBuf pBuffer) {
        pBuffer.writeInt(this._mFrame);
        pBuffer.writeInt(this._mNumFrames);
        ByteBufUtils.writeUTF8String((ByteBuf)pBuffer, (String)this._mPayload);
    }

    public static List<CTTClientSyncMessage> getPreparedNetworkMessages(String pPayload) {
        ArrayList<CTTClientSyncMessage> tMessages = new ArrayList<CTTClientSyncMessage>();
        List<String> tPayloads = CTTClientSyncMessage.splitByLength(pPayload, 4096);
        int tTotalFrames = tPayloads.size();
        for (int tFrame = 0; tFrame < tTotalFrames; ++tFrame) {
            tMessages.add(new CTTClientSyncMessage(tPayloads.get(tFrame), tFrame, tTotalFrames));
        }
        return tMessages;
    }

    private static List<String> splitByLength(String pInput, int pChunkSize) {
        ArrayList<String> tReturnList = new ArrayList<String>();
        for (int i = 0; i < pInput.length(); i += pChunkSize) {
            if (pInput.length() - i < pChunkSize) {
                tReturnList.add(pInput.substring(i));
                continue;
            }
            tReturnList.add(pInput.substring(i, i + pChunkSize));
        }
        return tReturnList;
    }

    public static class CTTClientSyncMessageHandler
    extends AbstractClientMessageHandler<CTTClientSyncMessage> {
        private static long _mLastReceived = 0L;
        private static HashMap<Integer, CTTClientSyncMessage> _mReceivedFrames;

        public IMessage handleClientMessage(EntityPlayer pPlayer, CTTClientSyncMessage pMessage, MessageContext pCtx) {
            if (_mLastReceived + 5000L < System.currentTimeMillis()) {
                _mReceivedFrames = new HashMap();
            }
            if (_mReceivedFrames.containsKey(pMessage._mFrame)) {
                return null;
            }
            _mReceivedFrames.put(pMessage._mFrame, pMessage);
            _mLastReceived = System.currentTimeMillis();
            if (_mReceivedFrames.size() == pMessage._mNumFrames) {
                boolean tIDX = false;
                StringBuilder tSb = new StringBuilder(32);
                TreeSet<Integer> keys = new TreeSet<Integer>(_mReceivedFrames.keySet());
                for (Integer currIdxKey : keys) {
                    tSb.append(CTTClientSyncMessageHandler._mReceivedFrames.get((Object)currIdxKey)._mPayload);
                }
                MainRegistry.Module_CustomToolTips.processServerConfig(tSb.toString());
                _mReceivedFrames = new HashMap();
            }
            return null;
        }
    }
}

