/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.modctt;

import com.dreammaster.main.MainRegistry;
import com.dreammaster.modctt.CustomToolTips;
import com.dreammaster.modctt.CustomToolTipsObjectFactory;
import com.dreammaster.network.msg.CTTClientSyncMessage;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import eu.usrv.yamcore.auxiliary.LogHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class CustomToolTipsHandler {
    private final LogHelper _mLogger = MainRegistry.Logger;
    private String _mConfigFileName;
    private final CustomToolTipsObjectFactory _mCttFactory = new CustomToolTipsObjectFactory();
    private CustomToolTips _mCustomToolTips;
    private boolean _mInitialized;

    public void processServerConfig(String pServerXML) {
        if (this.ReloadCustomToolTips(pServerXML)) {
            this._mLogger.info((Object)"[CTT] Received and activated configuration from server");
        } else {
            this._mLogger.warn((Object)"[CTT] Received invalid configuration from server; Not activated!");
        }
    }

    public CustomToolTipsHandler() {
        this.setConfigFileLocation();
        this._mInitialized = false;
    }

    public void setConfigFileLocation() {
        String locale = FMLCommonHandler.instance().getCurrentLanguage();
        String localeAwareFileName = String.format("config/%s/CustomToolTips_%s.xml", "GTNewHorizons", locale);
        this._mConfigFileName = new File(localeAwareFileName).isFile() ? localeAwareFileName : String.format("config/%s/CustomToolTips.xml", "GTNewHorizons");
    }

    public void InitSampleConfig() {
        this._mCustomToolTips = new CustomToolTips();
        this._mCustomToolTips.getToolTips().add(this._mCttFactory.createCustomItemToolTip("minecraft:stone", "Wow, such stone, much rock"));
        this._mCustomToolTips.getToolTips().add(this._mCttFactory.createCustomItemToolTip("minecraft:coal", "This is coal..."));
        this._mCustomToolTips.getToolTips().add(this._mCttFactory.createCustomItemToolTip("minecraft:coal:1", "...and this charcoal!"));
    }

    public boolean SaveCustomToolTips() {
        try {
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{CustomToolTips.class});
            Marshaller jaxMarsh = tJaxbCtx.createMarshaller();
            jaxMarsh.setProperty("jaxb.formatted.output", (Object)true);
            jaxMarsh.marshal((Object)this._mCustomToolTips, (OutputStream)new FileOutputStream(this._mConfigFileName, false));
            this._mLogger.debug((Object)"[CTT.SaveCustomToolTips] Config file written");
            return true;
        }
        catch (Exception e) {
            this._mLogger.error((Object)"[CTT.SaveCustomToolTips] Unable to create new CustomToolTips.xml. What did you do??");
            e.printStackTrace();
            return false;
        }
    }

    private String getXMLStream() {
        try {
            StringWriter tSW = new StringWriter();
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{CustomToolTips.class});
            Marshaller jaxMarsh = tJaxbCtx.createMarshaller();
            jaxMarsh.setProperty("jaxb.formatted.output", (Object)true);
            jaxMarsh.marshal((Object)this._mCustomToolTips, (Writer)tSW);
            return tSW.toString();
        }
        catch (Exception e) {
            this._mLogger.error((Object)"[CTT.getXMLStream] Unable to serialize tooltip objects");
            e.printStackTrace();
            return "";
        }
    }

    public void LoadConfig() {
        if (this._mInitialized) {
            this._mLogger.error((Object)"[CTT] Something just called LoadConfig AFTER it has been initialized!");
            return;
        }
        this._mLogger.debug((Object)"[CTT.LoadConfig] entering state: LOAD CONFIG");
        File tConfigFile = new File(this._mConfigFileName);
        if (!tConfigFile.exists()) {
            this._mLogger.debug((Object)"[CTT.LoadConfig] Config file not found, assuming first-start. Creating default one");
            this.InitSampleConfig();
            this.SaveCustomToolTips();
        }
        if (!this.reload()) {
            this._mLogger.warn((Object)"[CTT.LoadConfig] Configuration File seems to be damaged, loading does-nothing-evil default config. You should fix your file and reload it");
            MainRegistry.AddLoginError("[CustomToolTips] Config file not loaded due errors");
            this.InitSampleConfig();
        }
        this._mInitialized = true;
    }

    public boolean reload() {
        boolean tState = this.ReloadCustomToolTips("");
        if (this._mInitialized) {
            if (tState) {
                this.sendClientUpdate();
            } else {
                this._mLogger.error((Object)"[CTT.ReloadCustomToolTips] Reload of tooltip file failed. Not sending client update");
            }
        }
        return tState;
    }

    private void sendClientUpdate() {
        this.sendClientUpdate(null);
    }

    private void sendClientUpdate(EntityPlayer pPlayer) {
        String tPayload = this.getXMLStream();
        if (!tPayload.isEmpty()) {
            List<CTTClientSyncMessage> tPendingMessages = CTTClientSyncMessage.getPreparedNetworkMessages(tPayload);
            if (pPlayer instanceof EntityPlayerMP) {
                for (CTTClientSyncMessage tMsg : tPendingMessages) {
                    MainRegistry.NW.sendTo(tMsg, (EntityPlayerMP)pPlayer);
                }
            } else if (pPlayer == null) {
                for (CTTClientSyncMessage tMsg : tPendingMessages) {
                    MainRegistry.NW.sendToAll(tMsg);
                }
            } else {
                this._mLogger.error((Object)"[CTT.sendClientUpdate] Target is no EntityPlayer and not null");
            }
        } else {
            this._mLogger.error((Object)"[CTT.sendClientUpdate] Unable to send update to clients; Received empty serialized object");
        }
    }

    public boolean ReloadCustomToolTips(String pXMLContent) {
        boolean tResult = false;
        this._mLogger.debug((Object)"[CTT.ReloadCustomToolTips] will now try to load it's configuration");
        try {
            CustomToolTips tNewItemCollection;
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{CustomToolTips.class});
            Unmarshaller jaxUnmarsh = tJaxbCtx.createUnmarshaller();
            if (pXMLContent.isEmpty()) {
                File tConfigFile = new File(this._mConfigFileName);
                tNewItemCollection = (CustomToolTips)jaxUnmarsh.unmarshal(tConfigFile);
                this._mLogger.debug((Object)"[CTT.ReloadCustomToolTips] Config file has been loaded. Entering Verify state");
            } else {
                StringReader reader = new StringReader(pXMLContent);
                tNewItemCollection = (CustomToolTips)jaxUnmarsh.unmarshal((Reader)reader);
                this._mLogger.debug((Object)"[CTT.ReloadCustomToolTips] Received Server-Tooltips. Entering Verify state");
            }
            this._mCustomToolTips = tNewItemCollection;
            tResult = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tResult;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent pEvent) {
        if (pEvent.player instanceof EntityPlayerMP) {
            this.sendClientUpdate(pEvent.player);
        }
    }

    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent pEvent) {
        if (pEvent.entity == null) {
            return;
        }
        CustomToolTips.ItemToolTip itt = this._mCustomToolTips.FindItemToolTip(pEvent.itemStack);
        if (itt != null) {
            String[] tToolTips;
            for (String tPartTip : tToolTips = itt.getToolTip().split("\\\\n")) {
                pEvent.toolTip.add(tPartTip.replace("&", "\u00a7"));
            }
        }
    }
}

