/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.tooltip.TooltipHelper;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class MTEIndustrialMacerator
extends GTPPMultiBlockBase<MTEIndustrialMacerator>
implements ISurvivalConstructable {
    private int controllerTier = 1;
    private int structureTier;
    private int mCasing;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final int HORIZONTAL_OFF_SET = 1;
    private static final int VERTICAL_OFF_SET = 5;
    private static final int DEPTH_OFF_SET = 0;
    private static IStructureDefinition<MTEIndustrialMacerator> STRUCTURE_DEFINITION = null;

    @Nullable
    private static Integer getStructureCasingTier(Block b, int m) {
        if (b == GregTechAPI.sBlockCasings4 && m == 2) {
            return 1;
        }
        if (b == ModBlocks.blockCasingsMisc && m == 7) {
            return 2;
        }
        return null;
    }

    public MTEIndustrialMacerator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialMacerator(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialMacerator(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Macerator, Pulverizer, IMS";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo(TooltipHelper.parallelText("Voltage Tier * n") + " Parallels").addInfo("n=2 initially. n=8 after inserting Maceration Upgrade Chip").addStaticSpeedInfo(1.6f).addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 6, 3, true).addController("Bottom center").addCasingInfoMin("Maceration Stack Casings (After upgrade)", 26, false).addCasingInfoMin("Stable Titanium Casings (Before upgrade)", 26, false).addInputBus("Any casing", 1).addOutputBus("Any casing", 1).addEnergyHatch("Any casing", 1).addMaintenanceHatch("Any casing", 1).addMufflerHatch("Any casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialMacerator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"AAA", "AAA", "AAA"}, {"AAA", "A A", "AAA"}, {"AAA", "A A", "AAA"}, {"AAA", "A A", "AAA"}, {"AAA", "A A", "AAA"}, {"A~A", "AAA", "AAA"}})).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEIndustrialMacerator.class).atLeast(HatchElement.Energy, HatchElement.Maintenance, HatchElement.InputBus, HatchElement.Muffler, HatchElement.OutputBus).casingIndex(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings4, 2)).allowOnly(ForgeDirection.NORTH).dot(1).build(), StructureUtility.onElementPass(m -> ++m.mCasing, (IStructureElement)StructureUtility.ofBlocksTiered(MTEIndustrialMacerator::getStructureCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings4, (Object)2), (Object)Pair.of((Object)ModBlocks.blockCasingsMisc, (Object)7)), (Object)-1, (m, t) -> {
                m.structureTier = t;
            }, m -> m.structureTier))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 5, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 5, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.structureTier = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 5, 0)) {
            return false;
        }
        if (this.structureTier < 1 || this.mCasing < 26 || !this.checkHatch()) {
            return false;
        }
        this.updateHatchTexture();
        return this.structureTier >= this.controllerTier;
    }

    protected void updateHatchTexture() {
        int textureID = this.getCasingTextureId();
        for (Object h : this.mInputBusses) {
            ((MTEHatch)h).updateTexture(textureID);
        }
        for (Object h : this.mDualInputHatches) {
            h.updateTexture(textureID);
        }
        for (Object h : this.mOutputBusses) {
            ((MTEHatch)h).updateTexture(textureID);
        }
        for (Object h : this.mMaintenanceHatches) {
            ((MTEHatch)h).updateTexture(textureID);
        }
        for (Object h : this.mMufflerHatches) {
            ((MTEHatch)h).updateTexture(textureID);
        }
        for (Object h : this.mEnergyHatches) {
            ((MTEHatch)h).updateTexture(textureID);
        }
    }

    @Override
    public boolean checkHatch() {
        return !this.mMufflerHatches.isEmpty() && !this.mMaintenanceHatches.isEmpty() && !this.mOutputBusses.isEmpty() && (!this.mInputBusses.isEmpty() || !this.mDualInputHatches.isEmpty());
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.GTCEU_LOOP_MACERATOR;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Active;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Active_Glow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Glow;
    }

    @Override
    protected int getCasingTextureId() {
        if (this.structureTier == 2) {
            return TAE.GTPP_INDEX(7);
        }
        return GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings4, 2);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.maceratorRecipes;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -10;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getFrontFacing() != ForgeDirection.UP && !aBaseMetaTileEntity.hasCoverAtSide(ForgeDirection.UP) && !aBaseMetaTileEntity.getOpacityAtSide(ForgeDirection.UP)) {
            Random tRandom = aBaseMetaTileEntity.getWorld().field_73012_v;
            aBaseMetaTileEntity.getWorld().func_72869_a("smoke", (double)((float)aBaseMetaTileEntity.getXCoord() + 0.8f - tRandom.nextFloat() * 0.6f), (double)((float)aBaseMetaTileEntity.getYCoord() + 0.3f + tRandom.nextFloat() * 0.2f), (double)((float)aBaseMetaTileEntity.getZCoord() + 1.2f - tRandom.nextFloat() * 1.6f), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        ItemStack aGuiStack;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 0L && this.controllerTier == 1 && GregtechItemList.Maceration_Upgrade_Chip.isStackEqual(aGuiStack = this.getControllerSlot(), false, true)) {
            this.controllerTier = 2;
            this.mInventory[1] = ItemUtils.depleteStack(aGuiStack, 1);
            this.func_70296_d();
            this.mUpdated = true;
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        ItemStack heldItem;
        if (this.controllerTier == 1 && !aPlayer.func_70093_af() && GregtechItemList.Maceration_Upgrade_Chip.isStackEqual(heldItem = aPlayer.func_70694_bm(), false, true)) {
            this.controllerTier = 2;
            aPlayer.func_70062_b(0, ItemUtils.depleteStack(heldItem, 1));
            if (this.getBaseMetaTileEntity().isServerSide()) {
                this.func_70296_d();
                aPlayer.field_71071_by.func_70296_d();
                this.mUpdated = true;
            }
            return true;
        }
        return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.structureTier = aValue;
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.structureTier;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mTier", (byte)this.controllerTier);
        aNBT.func_74774_a("structureTier", (byte)this.structureTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.controllerTier = !aNBT.func_150297_b("mTier", 1) ? 2 : (int)aNBT.func_74771_c("mTier");
        this.structureTier = aNBT.func_74771_c("structureTier");
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        super.initDefaultModes(aNBT);
        this.controllerTier = aNBT == null || !aNBT.func_74764_b("mTier") ? 1 : (int)aNBT.func_74771_c("mTier");
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        if (this.controllerTier > 1) {
            aNBT.func_74774_a("mTier", (byte)this.controllerTier);
        }
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().noRecipeCaching().setSpeedBonus(0.625).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GTUtility.getTier(tVoltage));
        return Math.max(1, (this.controllerTier == 1 ? 2 : 8) * tTier);
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialMacerator;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("tier", this.controllerTier);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("tier")) {
            currentTip.add(StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(tag.func_74762_e("tier")) + EnumChatFormatting.RESET);
        }
    }
}

