/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import gregtech.GTMod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MTEHatchCustomFluidBase
extends MTEHatch {
    public final Fluid mLockedFluid;
    public final int mFluidCapacity;
    protected FluidStack mLockedStack = null;
    protected String mTempMod = null;

    public MTEHatchCustomFluidBase(Fluid aFluid, int aAmount, int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"Fluid Input for Multiblocks", "Capacity: " + GTUtility.formatNumbers(aAmount) + "L"}, new ITexture[0]);
        this.mLockedFluid = aFluid;
        this.mFluidCapacity = aAmount;
    }

    public MTEHatchCustomFluidBase(Fluid aFluid, int aAmount, String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
        this.mLockedFluid = aFluid;
        this.mFluidCapacity = aAmount;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (side == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0) {
            FluidStack fs = GTUtility.getFluidForFilledItem(aStack, true);
            return fs != null && fs.getFluid() == this.mLockedFluid;
        }
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing() && aIndex == 1;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.proxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.FLUID_STEAM_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.proxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.FLUID_STEAM_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    public void updateSlots() {
        if (this.mInventory[this.getInputSlot()] != null && this.mInventory[this.getInputSlot()].field_77994_a <= 0) {
            this.mInventory[this.getInputSlot()] = null;
        }
    }

    @Override
    public int getCapacity() {
        return this.mFluidCapacity;
    }

    @Override
    public String[] getDescription() {
        if (this.mLockedStack == null) {
            this.mLockedStack = FluidUtils.getFluidStack(this.mLockedFluid, 1);
        }
        int aFluidTemp = 0;
        boolean isSteam = false;
        if (this.mLockedFluid != null) {
            aFluidTemp = this.mLockedFluid.getTemperature();
            this.mTempMod = this.mLockedFluid.getName();
        }
        if (this.mTempMod.equalsIgnoreCase("steam")) {
            isSteam = true;
        }
        EnumChatFormatting aColour = EnumChatFormatting.BLUE;
        if (aFluidTemp <= -3000) {
            aColour = EnumChatFormatting.DARK_PURPLE;
        } else if (aFluidTemp >= -2999 && aFluidTemp <= -500) {
            aColour = EnumChatFormatting.DARK_BLUE;
        } else if (aFluidTemp >= -499 && aFluidTemp <= -50) {
            aColour = EnumChatFormatting.BLUE;
        } else if (aFluidTemp >= 30 && aFluidTemp <= 300) {
            aColour = EnumChatFormatting.AQUA;
        } else if (aFluidTemp >= 301 && aFluidTemp <= 800) {
            aColour = EnumChatFormatting.YELLOW;
        } else if (aFluidTemp >= 801 && aFluidTemp <= 1500) {
            aColour = EnumChatFormatting.GOLD;
        } else if (aFluidTemp >= 1501) {
            aColour = EnumChatFormatting.RED;
        }
        String aFluidName = "Accepted Fluid: " + aColour + (this.mLockedStack != null ? this.mLockedStack.getLocalizedName() : "Empty") + EnumChatFormatting.RESET;
        return new String[]{"Fluid Input for " + (isSteam ? "Steam " : "") + "Multiblocks", "Capacity: " + this.getCapacity() + "L", aFluidName, GTPPCore.GT_Tooltip.get()};
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return this.mLockedFluid.getName().equals(aFluid.getFluid().getName());
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchCustomFluidBase(this.mLockedFluid, this.mFluidCapacity, this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    protected FluidSlotWidget createFluidSlot() {
        return super.createFluidSlot().setFilter(f -> f == this.mLockedFluid);
    }
}

