/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import net.minecraft.util.EnumChatFormatting;

public class MTEHatchChiselBus
extends MTEHatchInputBus
implements IAddUIWidgets {
    public MTEHatchChiselBus(int id, String name, String nameRegional, int tier) {
        super(id, name, nameRegional, tier);
    }

    public MTEHatchChiselBus(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, MTEHatchChiselBus.getSlots(aTier), aDescription, aTextures);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < MTEHatchChiselBus.getSlots(this.mTier);
    }

    public static int getSlots(int aTier) {
        return (1 + aTier) * 16 + 1;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchChiselBus(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean allowSelectCircuit() {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Item Input Bus for " + EnumChatFormatting.YELLOW + "Industrial Chisel" + EnumChatFormatting.RESET, MTEHatchChiselBus.getSlots(this.mTier) - 1 + " + 1  Slots", "Added by: " + EnumChatFormatting.AQUA + "Quetz4l - " + EnumChatFormatting.RED + "[GT++]" + EnumChatFormatting.RESET};
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        int slotIndex = 0;
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int row = 0;
        while (row * 4 < this.inventoryHandler.getSlots() - 1) {
            int columnsToMake = Math.min(this.inventoryHandler.getSlots() - row * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                scrollable.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, slotIndex++).setPos(column * 18, row * 18).setSize(18, 18));
            }
            ++row;
        }
        builder.widget(scrollable.setSize(76, 72).setPos(52, 7));
        builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, slotIndex).setPos(18, 18).setSize(18, 18));
    }
}

