/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.StringUtils;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.FluidGT6;
import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.item.base.cell.BaseItemPlasmaCell;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.HashMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class FluidUtils {
    private static final HashMap<String, Fluid> sFluidCache = new HashMap();
    public static Fluid sGregtechHydrofluoricAcid = null;

    @Deprecated
    public static FluidStack getWater(int amount) {
        return Materials.Water.getFluid(amount);
    }

    @Deprecated
    public static FluidStack getDistilledWater(int amount) {
        return GTModHandler.getDistilledWater(amount);
    }

    public static FluidStack getHotWater(int amount) {
        return FluidUtils.getFluidStack("ic2hotwater", amount);
    }

    @Deprecated
    public static FluidStack getLava(int amount) {
        return Materials.Lava.getFluid(amount);
    }

    public static FluidStack getPahoehoeLava(int amount) {
        return FluidUtils.getFluidStack("ic2pahoehoelava", amount);
    }

    @Deprecated
    public static FluidStack getSteam(int amount) {
        return Materials.Steam.getGas(amount);
    }

    public static FluidStack getSuperHeatedSteam(int amount) {
        return FluidUtils.getFluidStack("ic2superheatedsteam", amount);
    }

    public static FluidStack getHydrofluoricAcid(int amount) {
        return FluidUtils.getFluidStack("hydrofluoricacid", amount);
    }

    public static FluidStack getHydrofluoricAcidGT(int amount) {
        if (sGregtechHydrofluoricAcid == null) {
            FluidStack aGTHF = FluidUtils.getFluidStack("hydrofluoricacid_gt5u", 1);
            sGregtechHydrofluoricAcid = aGTHF != null ? aGTHF.getFluid() : FluidUtils.getHydrofluoricAcid(1).getFluid();
        }
        return FluidUtils.getFluidStack(sGregtechHydrofluoricAcid, amount);
    }

    public static boolean doesHydrofluoricAcidGtExist() {
        if (sGregtechHydrofluoricAcid == null) {
            FluidUtils.getHydrofluoricAcidGT(1);
        }
        return sGregtechHydrofluoricAcid != null && sGregtechHydrofluoricAcid != FluidUtils.getHydrofluoricAcid(1).getFluid();
    }

    private static FluidStack createFluidStack(Fluid aFluid, int aAmount) {
        if (aFluid != null) {
            return new FluidStack(aFluid, aAmount);
        }
        return null;
    }

    public static FluidStack getFluidStack(String aFluidName, int aAmount) {
        Fluid aFluid = sFluidCache.get(aFluidName);
        if (aFluid != null) {
            return FluidUtils.createFluidStack(aFluid, aAmount);
        }
        Fluid aLookupFluid = FluidRegistry.getFluid((String)aFluidName);
        if (aLookupFluid != null) {
            sFluidCache.put(aFluidName, aLookupFluid);
            return FluidUtils.createFluidStack(aLookupFluid, aAmount);
        }
        return null;
    }

    public static FluidStack getFluidStack(FluidStack aFluidStack, int aAmount) {
        if (aFluidStack == null) {
            return null;
        }
        return new FluidStack(aFluidStack, aAmount);
    }

    public static FluidStack getFluidStack(Fluid aFluid, int aAmount) {
        if (aFluid == null) {
            return null;
        }
        return new FluidStack(aFluid, aAmount);
    }

    public static Fluid addGtFluid(String aName, String aLocalized, short[] rgba, int aState, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount) {
        return FluidUtils.addGtFluid(aName, aLocalized, rgba, aState, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, true);
    }

    public static Fluid addGtFluid(String aName, String aLocalized, short[] rgba, int aState, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, boolean aGenerateCell) {
        return FluidUtils.addGTFluid(aName, "fluid.autogenerated", aLocalized, rgba, aState, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, aGenerateCell);
    }

    public static Fluid addGTFluid(String aName, String aLocalized, short[] aRGBa, int aState, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, boolean aGenerateCell) {
        return FluidUtils.addGTFluid("molten." + aName, "molten.autogenerated", aLocalized, aRGBa, aState, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, aGenerateCell);
    }

    public static Fluid addGTFluidNonMolten(String aName, String aLocalized, short[] aRGBa, int aState, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, boolean aGenerateCell) {
        return FluidUtils.addGTFluid("fluid." + aName, "fluid.autogenerated", aLocalized, aRGBa, aState, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, aGenerateCell);
    }

    public static Fluid addGTFluidNoPrefix(String aName, String aLocalized, short[] aRGBa, int aState, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, boolean aGenerateCell) {
        return FluidUtils.addGTFluid(aName, "fluid.autogenerated", aLocalized, aRGBa, aState, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, aGenerateCell);
    }

    public static Fluid addGtGas(String aName, String aLocalized, short[] aRGBa, int aState, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, boolean aGenerateCell) {
        return FluidUtils.addGTFluid(aName, "fluid.autogenerated", aLocalized, aRGBa, aState, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, aGenerateCell);
    }

    public static Fluid addGTPlasma(Material aMaterial) {
        if (aMaterial.getLocalizedName().toLowerCase().contains("clay") || aMaterial.getComposites().size() > 1 || aMaterial.getLocalizedName().toLowerCase().contains("wrought")) {
            return null;
        }
        Logger.INFO("Generating a " + aMaterial.getLocalizedName() + " Plasma Cell");
        if (aMaterial.vComponentCount != 1) {
            Logger.INFO("Compound made from: ");
            for (MaterialStack x : aMaterial.getComposites()) {
                Logger.INFO(x.getStackMaterial().getLocalizedName());
            }
            Logger.INFO("Material is a composite, not generating plasma.");
            return null;
        }
        ItemStack temp = null;
        if (ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cellPlasma" + aMaterial.getUnlocalizedName(), 1) == null) {
            new BaseItemPlasmaCell(aMaterial);
            temp = aMaterial.getPlasmaCell(1);
        } else {
            temp = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cellPlasma" + aMaterial.getUnlocalizedName(), 1);
        }
        if (temp != null) {
            return FluidUtils.addGTFluid("plasma." + StringUtils.sanitizeString(aMaterial.getLocalizedName().toLowerCase()), "plasma.autogenerated", aMaterial.getLocalizedName() + " Plasma", aMaterial.getRGBA(), 3, 10000L, temp, ItemList.Cell_Empty.get(1L, new Object[0]), 1000, false);
        }
        return null;
    }

    public static Fluid addGTFluid(String aName, String aTexture, String aLocalized, short[] aRGBa, int aState, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, boolean aGenerateFilledCell) {
        String aNameNonMolten;
        Fluid rFluid;
        String aNameOriginal = aName;
        Logger.INFO("Generating Fluid for " + aName);
        aName = StringUtils.sanitizeString(aName.toLowerCase());
        String aLocalName = aLocalized == null ? aName : aLocalized;
        Fluid gFluid = FluidRegistry.getFluid((String)aName);
        FluidStack aCheck = FluidUtils.getWildcardFluidStack(aName.toLowerCase(), 1000);
        boolean register = false;
        if (aCheck != null) {
            rFluid = aCheck.getFluid();
        } else if (gFluid != null) {
            rFluid = gFluid;
        } else {
            rFluid = new FluidGT6(aName, aTexture, aRGBa != null ? aRGBa : Dyes._NULL.getRGBA());
            register = true;
        }
        if (register) {
            GTLanguageManager.addStringLocalization(rFluid.getUnlocalizedName(), aLocalName);
            if (FluidRegistry.registerFluid((Fluid)rFluid)) {
                switch (aState) {
                    case 0: {
                        rFluid.setGaseous(false);
                        rFluid.setViscosity(10000);
                        break;
                    }
                    case 1: 
                    case 4: {
                        rFluid.setGaseous(false);
                        rFluid.setViscosity(1000);
                        break;
                    }
                    case 2: {
                        rFluid.setGaseous(true);
                        rFluid.setDensity(-100);
                        rFluid.setViscosity(200);
                        break;
                    }
                    case 3: {
                        rFluid.setGaseous(true);
                        rFluid.setDensity(-10000);
                        rFluid.setViscosity(10);
                        rFluid.setLuminosity(15);
                    }
                }
            }
        }
        String string = aNameNonMolten = aLocalName.contains("Molten") ? aLocalName.replace("Molten", "") : aLocalName;
        if (aFullContainer == null) {
            ItemStack oreStack = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + aLocalName, 1);
            aFullContainer = oreStack;
            if (aFullContainer == null) {
                oreStack = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + aNameOriginal, 1);
                aFullContainer = oreStack;
                if (aFullContainer == null) {
                    oreStack = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + aNameNonMolten, 1);
                    aFullContainer = oreStack;
                    if (aFullContainer != null) {
                        Logger.INFO("Found cell for " + aNameNonMolten);
                    }
                } else {
                    Logger.INFO("Found cell for " + aNameOriginal);
                }
            } else {
                Logger.INFO("Found cell for " + aLocalName);
            }
        }
        BaseItemComponent tempCell = null;
        if (aGenerateFilledCell && aFullContainer == null) {
            String aMatName = aNameOriginal;
            if (aMatName.contains("molten.")) {
                aMatName = aMatName.replace("molten.", "");
                aMatName = aMatName.substring(0, 1).toUpperCase() + aMatName.substring(1);
            }
            if (aMatName.contains("fluid.")) {
                aMatName = aMatName.replace("fluid.", "");
                aMatName = aMatName.substring(0, 1).toUpperCase() + aMatName.substring(1);
            }
            Logger.INFO("Generating cell for " + aMatName + ", " + aLocalName);
            tempCell = new BaseItemComponent(aMatName, aLocalName, aRGBa);
            aFullContainer = new ItemStack((Item)tempCell);
        }
        if (rFluid.getTemperature() == new Fluid("test").getTemperature() || rFluid.getTemperature() <= 0) {
            rFluid.setTemperature((int)aTemperatureK);
        }
        if (aFullContainer != null && aEmptyContainer != null && !FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(rFluid, aFluidAmount), (ItemStack)aFullContainer, (ItemStack)aEmptyContainer)) {
            GTValues.RA.stdBuilder().itemInputs(ItemList.Cell_Empty.get(1L, new Object[0])).itemOutputs(aFullContainer).fluidInputs(new FluidStack(rFluid, aFluidAmount)).duration(4).eut(1).addTo(RecipeMaps.fluidCannerRecipes);
        }
        return rFluid;
    }

    public static boolean valid(Object aStack) {
        return aStack instanceof ItemStack && ((ItemStack)aStack).func_77973_b() != null && ((ItemStack)aStack).field_77994_a >= 0;
    }

    public static boolean invalid(Object aStack) {
        return !(aStack instanceof ItemStack) || ((ItemStack)aStack).func_77973_b() == null || ((ItemStack)aStack).field_77994_a < 0;
    }

    public static boolean equal(ItemStack aStack1, ItemStack aStack2) {
        return FluidUtils.equal(aStack1, aStack2, false);
    }

    public static boolean equal(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return aStack1 != null && aStack2 != null && FluidUtils.equal_(aStack1, aStack2, aIgnoreNBT);
    }

    public static boolean equal_(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return !(aStack1.func_77973_b() != aStack2.func_77973_b() || !aIgnoreNBT && (aStack1.func_77978_p() == null != (aStack2.func_77978_p() == null) || aStack1.func_77978_p() != null && !aStack1.func_77978_p().equals((Object)aStack2.func_77978_p())) || FluidUtils.meta(aStack1) != FluidUtils.meta(aStack2) && FluidUtils.meta(aStack1) != Short.MAX_VALUE && FluidUtils.meta(aStack2) != Short.MAX_VALUE);
    }

    public static ItemStack copy(Object ... aStacks) {
        for (Object tStack : aStacks) {
            if (!FluidUtils.valid(tStack)) continue;
            return ((ItemStack)tStack).func_77946_l();
        }
        return null;
    }

    public static ItemStack copyMeta(long aMetaData, Object ... aStacks) {
        ItemStack rStack = FluidUtils.copy(aStacks);
        if (FluidUtils.invalid(rStack)) {
            return null;
        }
        return FluidUtils.meta(rStack, aMetaData);
    }

    public static short meta(ItemStack aStack) {
        return (short)Items.field_151008_G.getDamage(aStack);
    }

    public static ItemStack meta(ItemStack aStack, long aMeta) {
        Items.field_151008_G.setDamage(aStack, (int)((short)aMeta));
        return aStack;
    }

    public static ItemStack amount(long aAmount, Object ... aStacks) {
        ItemStack rStack = FluidUtils.copy(aStacks);
        if (FluidUtils.invalid(rStack)) {
            return null;
        }
        rStack.field_77994_a = (int)aAmount;
        return rStack;
    }

    public static ItemStack container(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (FluidUtils.invalid(aStack)) {
            return null;
        }
        if (aStack.func_77973_b().hasContainerItem(aStack)) {
            return aStack.func_77973_b().getContainerItem(aStack);
        }
        if (FluidUtils.equal(aStack, ItemList.Cell_Empty.get(1L, new Object[0]), true)) {
            return null;
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
            ItemStack tStack = FluidUtils.amount(1L, aStack);
            ((IFluidContainerItem)aStack.func_77973_b()).drain(tStack, Integer.MAX_VALUE, true);
            if (!FluidUtils.equal(aStack, tStack)) {
                return tStack;
            }
            return null;
        }
        if (FluidUtils.equal(aStack, ItemList.IC2_ForgeHammer.get(1L, new Object[0])) || FluidUtils.equal(aStack, ItemList.IC2_WireCutter.get(1L, new Object[0]))) {
            return FluidUtils.copyMeta(FluidUtils.meta(aStack) + 1, aStack);
        }
        return null;
    }

    public static ItemStack container(ItemStack aStack, boolean aCheckIFluidContainerItems, int aStacksize) {
        return FluidUtils.amount(aStacksize, FluidUtils.container(aStack, aCheckIFluidContainerItems));
    }

    public static Fluid generateFluidNonMolten(String unlocalizedName, String localizedName, int MeltingPoint, short[] RGBA, ItemStack dustStack, ItemStack dustStack2) {
        return FluidUtils.generateFluidNonMolten(unlocalizedName, localizedName, MeltingPoint, RGBA, dustStack, dustStack2, 144, true);
    }

    public static Fluid generateFluidNonMolten(String unlocalizedName, String localizedName, int MeltingPoint, short[] RGBA, ItemStack dustStack, ItemStack dustStack2, boolean aGenerateCell) {
        return FluidUtils.generateFluidNonMolten(unlocalizedName, localizedName, MeltingPoint, RGBA, dustStack, dustStack2, 144, aGenerateCell);
    }

    public static Fluid generateFluidNonMolten(String unlocalizedName, String localizedName, int MeltingPoint, short[] RGBA, ItemStack dustStack, ItemStack dustStack2, int amountPerItem, boolean aGenerateCell) {
        FluidStack aFStack;
        if (dustStack == null) {
            dustStack = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("dust" + StringUtils.sanitizeString(localizedName), 1);
        }
        if ((aFStack = FluidUtils.getFluidStack(unlocalizedName.toLowerCase(), 1)) == null) {
            Logger.WARNING("Generating our own fluid.");
            Fluid gtFluid = FluidUtils.addGTFluidNonMolten(unlocalizedName, localizedName, RGBA, 4, MeltingPoint, null, ItemList.Cell_Empty.get(1L, new Object[0]), 1000, aGenerateCell);
            if (dustStack != null) {
                GTValues.RA.stdBuilder().itemInputs(dustStack).fluidOutputs(FluidUtils.getFluidStack(gtFluid, amountPerItem)).duration(20).eut(16).addTo(RecipeMaps.fluidExtractionRecipes);
            }
            if (dustStack2 != null) {
                GTValues.RA.stdBuilder().itemInputs(dustStack2).fluidOutputs(FluidUtils.getFluidStack(gtFluid, amountPerItem)).duration(20).eut(16).addTo(RecipeMaps.fluidExtractionRecipes);
            }
            return gtFluid;
        }
        Logger.INFO("FLUID GENERATION FAILED FOR " + localizedName + ", ALREADY EXISTS");
        return aFStack.getFluid();
    }

    public static Fluid generateFluidNoPrefix(String unlocalizedName, String localizedName, int MeltingPoint, short[] RGBA) {
        return FluidUtils.generateFluidNoPrefix(unlocalizedName, localizedName, MeltingPoint, RGBA, true);
    }

    public static Fluid generateFluidNoPrefix(String unlocalizedName, String localizedName, int MeltingPoint, short[] RGBA, boolean aGenerateCell) {
        Fluid gtFluid;
        if (FluidUtils.getFluidStack(unlocalizedName.toLowerCase(), 1) == null) {
            Logger.WARNING("Generating our own fluid.");
            gtFluid = FluidUtils.addGTFluidNoPrefix(unlocalizedName, localizedName, RGBA, 4, MeltingPoint, null, ItemList.Cell_Empty.get(1L, new Object[0]), 1000, aGenerateCell);
        } else {
            gtFluid = FluidUtils.getFluidStack(unlocalizedName.toLowerCase(), 1).getFluid();
        }
        return gtFluid;
    }

    public static Fluid generateGas(String unlocalizedName, String localizedName, int MeltingPoint, short[] RGBA, boolean aGenerateCell) {
        Fluid gtFluid;
        if (FluidUtils.getFluidStack(unlocalizedName.toLowerCase(), 1) == null) {
            Logger.WARNING("Generating our own gas.");
            gtFluid = FluidUtils.addGtGas(unlocalizedName, localizedName, RGBA, 3, MeltingPoint, null, ItemList.Cell_Empty.get(1L, new Object[0]), 1000, aGenerateCell);
        } else {
            gtFluid = FluidUtils.getFluidStack(unlocalizedName.toLowerCase(), 1).getFluid();
        }
        return gtFluid;
    }

    public static boolean doesFluidExist(String aFluidName) {
        FluidStack aFStack1 = FluidUtils.getFluidStack("molten." + aFluidName.toLowerCase(), 1);
        FluidStack aFStack2 = FluidUtils.getFluidStack("fluid." + aFluidName.toLowerCase(), 1);
        FluidStack aFStack3 = FluidUtils.getFluidStack(aFluidName.toLowerCase(), 1);
        FluidStack aFStack4 = FluidUtils.getFluidStack(aFluidName, 1);
        FluidStack aFStack5 = FluidUtils.getFluidStack("liquid_" + aFluidName.toLowerCase(), 1);
        FluidStack aFStack6 = FluidUtils.getFluidStack("liquid." + aFluidName.toLowerCase(), 1);
        return aFStack1 != null || aFStack2 != null || aFStack3 != null || aFStack4 != null || aFStack5 != null || aFStack6 != null;
    }

    public static FluidStack getWildcardFluidStack(String aFluidName, int amount) {
        FluidStack aFStack1 = FluidUtils.getFluidStack(aFluidName, amount);
        FluidStack aFStack2 = FluidUtils.getFluidStack(aFluidName.toLowerCase(), amount);
        FluidStack aFStack3 = FluidUtils.getFluidStack("molten." + aFluidName.toLowerCase(), amount);
        FluidStack aFStack4 = FluidUtils.getFluidStack("fluid." + aFluidName.toLowerCase(), amount);
        FluidStack aFStack5 = FluidUtils.getFluidStack("liquid_" + aFluidName.toLowerCase(), amount);
        FluidStack aFStack6 = FluidUtils.getFluidStack("liquid." + aFluidName.toLowerCase(), amount);
        if (aFStack1 != null) {
            return aFStack1;
        }
        if (aFStack2 != null) {
            return aFStack2;
        }
        if (aFStack3 != null) {
            return aFStack3;
        }
        if (aFStack4 != null) {
            return aFStack4;
        }
        if (aFStack5 != null) {
            return aFStack5;
        }
        return aFStack6;
    }

    public static FluidStack getWildcardFluidStack(Materials aMaterial, int amount) {
        FluidStack aFStack1 = aMaterial.getFluid(amount);
        FluidStack aFStack2 = aMaterial.getGas(amount);
        FluidStack aFStack3 = aMaterial.getMolten(amount);
        FluidStack aFStack4 = aMaterial.getSolid(amount);
        if (aFStack1 != null) {
            return aFStack1;
        }
        if (aFStack2 != null) {
            return aFStack2;
        }
        if (aFStack3 != null) {
            return aFStack3;
        }
        return aFStack4;
    }

    @Deprecated
    public static FluidStack getAir(int aAmount) {
        return Materials.Air.getGas(aAmount);
    }
}

