/*
 * Decompiled with CFR 0.152.
 */
package gregtech.crossmod.navigator;

import com.gtnewhorizons.navigator.api.NavigatorApi;
import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.steps.UniversalInteractableStep;
import com.gtnewhorizons.navigator.api.util.DrawUtils;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.net.GTPacketClearPowerfail;
import gregtech.api.util.GTDataUtils;
import gregtech.api.util.GTTextBuilder;
import gregtech.common.data.GTPowerfailTracker;
import gregtech.crossmod.navigator.PowerfailLocationWrapper;
import java.text.DateFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class PowerfailRenderStep
extends UniversalInteractableStep<PowerfailLocationWrapper> {
    private static final ResourceLocation CLICK_SOUND = new ResourceLocation("gui.button.press");
    private static final int FONT_HEIGHT = Minecraft.func_71410_x().field_71466_p.field_78288_b;

    public PowerfailRenderStep(PowerfailLocationWrapper location) {
        super((IWaypointAndLocationProvider)location);
        this.setFontScale(1.2f);
        this.setMinScale(1);
    }

    public void preRender(double topX, double topY, float drawScale, double zoom) {
        double iconSize = this.isXaero ? 10.0 * zoom : (double)(32.0f * drawScale);
        double blockWidth = Math.pow(2.0, zoom);
        double padding = -(iconSize - blockWidth) / 2.0;
        this.setSize(iconSize);
        this.setOffset(padding);
    }

    public void draw(double topX, double topY, float drawScale, double zoom) {
        if (!((PowerfailLocationWrapper)this.location).highlighted) {
            return;
        }
        DrawUtils.drawLabel((String)((PowerfailLocationWrapper)this.location).powerfail.toSummary().toString(), (double)(topX + this.width / 2.0), (double)(topY - (double)FONT_HEIGHT - 5.0 + this.height * 1.5), (int)0xFFFFFF, (int)0, (boolean)true, (double)this.getFontScale());
        DrawUtils.drawQuad((IIcon)GTMod.clientProxy().powerfailRenderer.powerfailIcon, (double)topX, (double)topY, (double)this.width, (double)this.height, (int)0xFFFFFF, (int)255);
    }

    public void getTooltip(List<String> list) {
        GTPowerfailTracker.Powerfail p = ((PowerfailLocationWrapper)this.location).powerfail;
        String[] lines = new GTTextBuilder("GT5U.gui.chat.powerfail.waypoint.tooltip").setBase(EnumChatFormatting.GRAY).addName(p.getMTEName()).addCoord(p.x, p.y, p.z).addNumber(p.count).addValue(DateFormat.getDateTimeInstance().format(p.lastOccurrence)).addName(Keyboard.getKeyName((int)NavigatorApi.ACTION_KEY.func_151463_i())).toString().split("\\\\n");
        list.addAll(GTDataUtils.mapToList(lines, s -> EnumChatFormatting.GRAY + s));
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return (double)mouseX >= this.getX() && (double)mouseX <= this.getX() + this.width && (double)mouseY >= this.getY() && (double)mouseY <= this.getY() + this.height;
    }

    public void onActionKeyPressed() {
        super.onActionKeyPressed();
        PowerfailRenderStep.playClickSound();
        GTValues.NW.sendToServer(new GTPacketClearPowerfail(((PowerfailLocationWrapper)this.location).powerfail));
    }

    private static void playClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)CLICK_SOUND, (float)1.0f));
    }
}

