/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationUnitBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEPurificationUnitFlocculation
extends MTEPurificationUnitBase<MTEPurificationUnitFlocculation>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_MAIN_SURVIVAL = "main_survival";
    private static final int STRUCTURE_X_OFFSET = 4;
    private static final int STRUCTURE_Y_OFFSET = 3;
    private static final int STRUCTURE_Z_OFFSET = 0;
    public static final long INPUT_CHEMICAL_PER_LEVEL = 100000L;
    private static final long WASTE_WATER_PER_LEVEL = 100000L;
    public static final float SUCCESS_PER_LEVEL = 10.0f;
    private static final int CONSUME_INTERVAL = 20;
    private static final Materials INPUT_CHEMICAL = Materials.PolyAluminiumChloride;
    private static final Materials OUTPUT_WASTE = Materials.FlocculationWasteLiquid;
    private long inputFluidConsumed = 0L;
    private static final String[][] structure = new String[][]{{"         ", "         ", " BBBBBBB ", " BBB~BBB ", " BBBBBBB "}, {"         ", "         ", " B     B ", " BWWWWWB ", " BCCCCCB "}, {"         ", "         ", " B     B ", " GWWWWWG ", " BCAAACB "}, {"         ", "         ", " B     B ", " GWWWWWG ", " BCAAACB "}, {"         ", "         ", " B     B ", " GWWWWWG ", " BCAAACB "}, {"         ", " EE   EE ", " BE   EB ", " BEWWWEB ", " BCCCCCB "}, {"D       D", "DEE   EED", "DBBBBBBBD", "DBBBBBBBD", "DBBBBBBBD"}, {"DD     DD", "DD     DD", "DD     DD", "DD     DD", "DD     DD"}};
    private static final int MAIN_CASING_INDEX = MTEPurificationUnitFlocculation.getTextureIndex(GregTechAPI.sBlockCasings9, 6);
    private int casingCount = 0;
    private static final int MIN_CASING = 56;
    private static final IStructureDefinition<MTEPurificationUnitFlocculation> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", structure).addShape("main_survival", (String[][])Arrays.stream(structure).map(sa -> (String[])Arrays.stream(sa).map(s -> s.replaceAll("W", " ")).toArray(String[]::new)).toArray(x$0 -> new String[x$0][])).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)11)).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeastList(t.getAllowedHatches()).casingIndex(MAIN_CASING_INDEX).dot(1).build()), StructureUtility.onElementPass(t -> ++t.casingCount, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)6))})).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)5)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)4)).addElement('E', GTStructureUtility.ofFrame(Materials.Adamantium)).addElement('W', GTStructureUtility.ofAnyWater(false)).addElement('G', StructureUtility.ofBlockAnyMeta((Block)GregTechAPI.sBlockTintedGlass)).build();

    List<IHatchElement<? super MTEPurificationUnitFlocculation>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputBus, (Object)HatchElement.InputHatch, (Object)HatchElement.OutputBus, (Object)HatchElement.OutputHatch);
    }

    public MTEPurificationUnitFlocculation(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPurificationUnitFlocculation(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPurificationUnitFlocculation(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(MAIN_CASING_INDEX), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(MAIN_CASING_INDEX), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(MAIN_CASING_INDEX)};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 4, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        int built = this.survivalBuildPiece(STRUCTURE_PIECE_MAIN_SURVIVAL, stackSize, 4, 3, 0, elementBudget, env, true);
        if (built == -1) {
            GTUtility.sendChatToPlayer(env.getActor(), EnumChatFormatting.GREEN + "Auto placing done ! Now go place the water yourself !");
            return 0;
        }
        return built;
    }

    @Override
    public IStructureDefinition<MTEPurificationUnitFlocculation> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingCount = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 4, 3, 0)) {
            return false;
        }
        if (this.mInputHatches.size() > 3) {
            return false;
        }
        if (this.mOutputHatches.size() > 3) {
            return false;
        }
        if (this.casingCount < 56) {
            return false;
        }
        return super.checkMachine(aBaseMetaTileEntity, aStack);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Purification Unit").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "Water Tier: " + EnumChatFormatting.WHITE + GTUtility.formatNumbers(this.getWaterTier()) + EnumChatFormatting.RESET).addInfo("Must be linked to a Purification Plant using a data stick to work").addSeparator().addInfo("Supply with " + EnumChatFormatting.WHITE + MTEPurificationUnitFlocculation.INPUT_CHEMICAL.mLocalizedName + EnumChatFormatting.GRAY + " to operate").addInfo("Outputs " + EnumChatFormatting.WHITE + MTEPurificationUnitFlocculation.OUTPUT_WASTE.mLocalizedName + EnumChatFormatting.GRAY + " that can be recycled").addSeparator().addInfo("During operation, will consume ALL " + EnumChatFormatting.WHITE + MTEPurificationUnitFlocculation.INPUT_CHEMICAL.mLocalizedName + EnumChatFormatting.GRAY + " in the input hatch").addInfo("At the end of the recipe, for every " + EnumChatFormatting.RED + 100000L + "L " + EnumChatFormatting.GRAY + "of " + EnumChatFormatting.WHITE + MTEPurificationUnitFlocculation.INPUT_CHEMICAL.mLocalizedName + EnumChatFormatting.GRAY + " consumed").addInfo("gain an additive " + EnumChatFormatting.RED + 10.0f + "%" + EnumChatFormatting.GRAY + " increase to success. If total fluid supplied is not").addInfo("a multiple of " + EnumChatFormatting.RED + 100000L + "L" + EnumChatFormatting.GRAY + ", a penalty to success is applied using the following formula:").addInfo(EnumChatFormatting.GREEN + "Success = Success * 2^(-10 * Overflow ratio)").addSeparator().addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Step three in purifying water is to remove microscopic contaminants such as dusts, microplastics and other").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "pollutants using a clarifying agent (In this case, polyaluminium chloride) to cause flocculation - the process").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "of aggregating dispersed suspended particles from a solution into larger clumps for further filtration.").beginStructureBlock(9, 5, 8, false).addController("Front center").addCasingInfoRangeColored("Slick Sterile Flocculation Casing", EnumChatFormatting.GRAY, 56, 65, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Sterile Water Plant Casing", EnumChatFormatting.GRAY, 30, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Reinforced Sterile Water Plant Casing", EnumChatFormatting.GRAY, 16, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Tinted Industrial Glass", EnumChatFormatting.GRAY, 6, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Adamantium Frame Box", EnumChatFormatting.GRAY, 12, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Filter Machine Casing", EnumChatFormatting.GRAY, 9, EnumChatFormatting.GOLD, false).addOutputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addInputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "-" + EnumChatFormatting.GOLD + "3", 1).addOutputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "-" + EnumChatFormatting.GOLD + "3", 1).toolTipFinisher(GTValues.AuthorNotAPenguin);
        return tt;
    }

    @Override
    public void startCycle(int cycleTime, int progressTime) {
        super.startCycle(cycleTime, progressTime);
        this.inputFluidConsumed = 0L;
    }

    @Override
    public void endCycle() {
        super.endCycle();
        int levels = this.calculateBoostLevels();
        long amount = (long)levels * 100000L;
        this.addFluidOutputs(new FluidStack[]{OUTPUT_WASTE.getFluid(amount)});
        this.inputFluidConsumed = 0L;
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.runMachine(aBaseMetaTileEntity, aTick);
        if (aTick % 20L == 0L && this.mMaxProgresstime > 0) {
            ArrayList<FluidStack> fluids = this.getStoredFluids();
            for (FluidStack fluid : fluids) {
                if (!fluid.getFluid().equals(MTEPurificationUnitFlocculation.INPUT_CHEMICAL.mFluid)) continue;
                this.inputFluidConsumed += (long)fluid.amount;
                if (this.depleteInput(fluid)) continue;
                this.stopMachine(ShutDownReasonRegistry.outOfFluid(fluid));
            }
        }
    }

    private int calculateBoostLevels() {
        return (int)Math.floor((float)this.inputFluidConsumed / 100000.0f);
    }

    @Override
    public float calculateFinalSuccessChance() {
        int levels = this.calculateBoostLevels();
        long targetAmount = (long)levels * 100000L;
        long overflow = this.inputFluidConsumed - targetAmount;
        float boost = 10.0f * (float)levels;
        if (overflow > 0L) {
            float overflowPct = (float)overflow / 100000.0f;
            float penaltyMultiplier = (float)Math.pow(2.0, (double)overflowPct * -10.0);
            return Math.max(0.0f, Math.min(100.0f, this.currentRecipeChance + boost) * penaltyMultiplier);
        }
        return Math.min(100.0f, this.currentRecipeChance + boost);
    }

    @Override
    public int getWaterTier() {
        return 3;
    }

    @Override
    public long getBasePowerUsage() {
        return TierEU.RECIPE_ZPM;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.purificationFlocculationRecipes;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> infoData = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        infoData.add(StatCollector.func_74837_a((String)"GT5U.infodata.purification_unit_flocculation.consumed", (Object[])new Object[]{MTEPurificationUnitFlocculation.INPUT_CHEMICAL.mLocalizedName, "" + EnumChatFormatting.RED + this.inputFluidConsumed}));
        return infoData.toArray(new String[0]);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("mInputFluidConsumed", this.inputFluidConsumed);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.inputFluidConsumed = aNBT.func_74763_f("mInputFluidConsumed");
    }

    @Override
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_COAGULATION_LOOP;
    }
}

