/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.MachineType;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTUtility;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MTERockBreaker
extends MTEBasicMachine {
    private static final Int2ObjectMap<Set<RockBreakerRecipe>> ROCK_BREAKER_RECIPES = new Int2ObjectOpenHashMap();

    public MTERockBreaker(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, MachineType.ROCKBREAKER.tooltipDescription(), 1, 1, TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER_GLOW).glow().build()));
    }

    public MTERockBreaker(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTERockBreaker(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.rockBreakerFakeRecipes;
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack) && this.getRecipeMap().containsInput(aStack);
    }

    @Override
    public boolean allowSelectCircuit() {
        return true;
    }

    @Override
    public int checkRecipe() {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        Block topBlock = aBaseMetaTileEntity.getBlockOffset(0, 1, 0);
        Block bottomBlock = aBaseMetaTileEntity.getBlockOffset(0, -1, 0);
        Block[] sideBlocks = new Block[]{aBaseMetaTileEntity.getBlockOffset(0, 0, 1), aBaseMetaTileEntity.getBlockOffset(0, 0, -1), aBaseMetaTileEntity.getBlockOffset(-1, 0, 0), aBaseMetaTileEntity.getBlockOffset(1, 0, 0)};
        ItemStack circuitStack = this.func_70301_a(this.getCircuitSlot());
        int circuitNum = circuitStack == null ? -1 : circuitStack.func_77960_j();
        Set potentialRecipes = (Set)ROCK_BREAKER_RECIPES.get(circuitNum);
        if (potentialRecipes == null) {
            potentialRecipes = (Set)ROCK_BREAKER_RECIPES.get(-1);
        }
        for (RockBreakerRecipe recipe : potentialRecipes) {
            if (!recipe.testInWorld(sideBlocks, topBlock, bottomBlock) || !recipe.testInputs(this.getInputAt(0))) continue;
            ItemStack output = recipe.getOutputItem();
            if (!this.canOutput(output)) continue;
            if (recipe.isInputConsumed()) {
                --this.getInputAt((int)0).field_77994_a;
            }
            this.calculateOverclockedNess((int)TierEU.RECIPE_LV, recipe.getDuration());
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            this.mOutputItems[0] = output;
            return 2;
        }
        return 0;
    }

    public static void addRockBreakerRecipe(UnaryOperator<RockBreakerRecipe.Builder> u) {
        RockBreakerRecipe recipe = ((RockBreakerRecipe.Builder)u.apply(new RockBreakerRecipe.Builder())).build();
        ((Set)ROCK_BREAKER_RECIPES.computeIfAbsent(recipe.circuit, $ -> new HashSet())).add(recipe);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GTCEU_LOOP_FIRE;
    }

    public static class RockBreakerRecipe {
        private final Block topBlock;
        private final Block bottomBlock;
        private final Block[] sideBlocks;
        private final Block[] anywhereBlocks;
        private final int circuit;
        private final int duration;
        private final ItemStack inputItem;
        private final boolean inputConsumed;
        private final ItemStack outputItem;

        private RockBreakerRecipe(Block topBlock, Block bottomBlock, Block[] sideBlocks, Block[] anywhereBlocks, int circuit, int duration, ItemStack inputItem, boolean inputConsumed, ItemStack outputItem) {
            this.topBlock = topBlock;
            this.bottomBlock = bottomBlock;
            this.sideBlocks = sideBlocks;
            this.anywhereBlocks = anywhereBlocks;
            this.circuit = circuit;
            this.duration = duration;
            this.inputItem = inputItem;
            this.inputConsumed = inputConsumed;
            this.outputItem = outputItem;
        }

        public boolean testInWorld(Block[] sideBlocks, Block topBlock, Block bottomBlock) {
            if (this.topBlock != null && this.topBlock != topBlock) {
                return false;
            }
            if (this.bottomBlock != null && this.bottomBlock != bottomBlock) {
                return false;
            }
            if (this.sideBlocks != null) {
                for (Block sideBlock : this.sideBlocks) {
                    if (ArrayUtils.contains((Object[])sideBlocks, (Object)sideBlock)) continue;
                    return false;
                }
            }
            if (this.anywhereBlocks != null) {
                for (Block anywhereBlock : this.anywhereBlocks) {
                    if (topBlock == anywhereBlock || bottomBlock == anywhereBlock || ArrayUtils.contains((Object[])sideBlocks, (Object)anywhereBlock)) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean testInputs(ItemStack inputStack) {
            if (this.inputItem != null) {
                return GTUtility.areStacksEqual(inputStack, this.inputItem);
            }
            return true;
        }

        private int getDuration() {
            return this.duration;
        }

        private boolean isInputConsumed() {
            return this.inputConsumed;
        }

        private ItemStack getOutputItem() {
            return this.outputItem.func_77946_l();
        }

        public static class Builder {
            private Block topBlock;
            private Block bottomBlock;
            private Block[] sideBlocks;
            private Block[] anywhereBlocks;
            private int circuit = -1;
            private int duration = 16;
            private ItemStack inputItem;
            private boolean inputConsumed;
            private ItemStack outputItem;
            private String recipeDescription = "IT'S FREE! Place Lava on Side";

            public Builder topBlock(Block block) {
                this.topBlock = block;
                return this;
            }

            public Builder bottomBlock(Block block) {
                this.bottomBlock = block;
                return this;
            }

            public Builder sideBlocks(Block ... blocks) {
                this.sideBlocks = blocks;
                return this;
            }

            public Builder anywhereBlocks(Block ... blocks) {
                this.anywhereBlocks = blocks;
                return this;
            }

            public Builder circuit(int number) {
                this.circuit = number;
                return this;
            }

            public Builder duration(int ticks) {
                this.duration = ticks;
                return this;
            }

            public Builder inputItem(ItemStack inputItem, boolean consumed) {
                this.inputItem = inputItem;
                this.inputConsumed = consumed;
                return this;
            }

            public Builder outputItem(ItemStack outputItem) {
                this.outputItem = outputItem;
                return this;
            }

            public Builder recipeDescription(String desc) {
                this.recipeDescription = desc;
                return this;
            }

            public RockBreakerRecipe build() {
                if (this.outputItem == null) {
                    throw new IllegalArgumentException("Rock Breaker Output Item must be set!");
                }
                if (this.sideBlocks != null && this.sideBlocks.length > 4) {
                    throw new IllegalArgumentException("Cannot have more than 4 Rock Breaker side blocks!");
                }
                if (this.anywhereBlocks != null && this.anywhereBlocks.length > 6) {
                    throw new IllegalArgumentException("Cannot have more than 6 Rock Breaker anywhere blocks!");
                }
                this.addFakeRecipe();
                return new RockBreakerRecipe(this.topBlock, this.bottomBlock, this.sideBlocks, this.anywhereBlocks, this.circuit, this.duration, this.inputItem, this.inputConsumed, this.outputItem);
            }

            private void addFakeRecipe() {
                GTRecipeBuilder b = GTValues.RA.stdBuilder().itemOutputs(this.outputItem.func_77946_l()).duration(this.duration).eut(TierEU.RECIPE_LV).ignoreCollision().fake();
                ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
                if (this.inputItem != null) {
                    if (this.inputConsumed) {
                        inputs.add(this.inputItem.func_77946_l());
                    } else {
                        inputs.add(GTUtility.copyAmount(0, this.inputItem));
                    }
                } else {
                    inputs.add(ItemList.Display_ITS_FREE.getWithName(1L, this.recipeDescription, new Object[0]));
                }
                if (this.circuit != -1) {
                    inputs.add(GTUtility.getIntegratedCircuit(this.circuit));
                }
                b.itemInputs(inputs.toArray(new ItemStack[0]));
                b.addTo(RecipeMaps.rockBreakerFakeRecipes);
            }
        }
    }
}

