/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import gregtech.GTMod;
import gregtech.api.items.MetaGeneratedItem;
import gregtech.common.GTClient;
import gregtech.common.render.GTRenderUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RainbowOverlayMetaItemRenderer
implements IItemRenderer {
    private float baseR = 1.0f;
    private float baseG = 1.0f;
    private float baseB = 1.0f;

    public RainbowOverlayMetaItemRenderer(short[] rgba) {
        this.baseR = (float)rgba[0] / 255.0f;
        this.baseG = (float)rgba[1] / 255.0f;
        this.baseB = (float)rgba[2] / 255.0f;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        Item item2 = item.func_77973_b();
        if (item2 instanceof MetaGeneratedItem) {
            MetaGeneratedItem mgItem = (MetaGeneratedItem)item2;
            IIcon[] icons = mgItem.mIconList[item.func_77960_j() - mgItem.mOffset];
            if (icons != null && icons.length > 0 && icons[0] != null) {
                GTClient clientProxy = GTMod.clientProxy();
                long animationTicks = clientProxy.getAnimationTicks();
                float partialTicks = clientProxy.getPartialRenderTicks();
                Color color = Color.getHSBColor(((float)(animationTicks % 180L) + partialTicks) % 90.0f / 90.0f, 0.4f, 0.9f);
                float modR = (float)color.getRed() / 255.0f;
                float modG = (float)color.getGreen() / 255.0f;
                float modB = (float)color.getBlue() / 255.0f;
                GL11.glColor3f((float)(this.baseR * modR), (float)(this.baseG * modG), (float)(this.baseB * modB));
                GTRenderUtil.renderItem(type, icons[0]);
            }
        }
        GL11.glPopMatrix();
    }
}

