/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import gregtech.GTMod;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.ISBRContext;
import gregtech.common.render.GTIconFlipped;
import gregtech.common.render.GTTextureBase;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GTRenderedTexture
extends GTTextureBase
implements ITexture,
IColorModulationContainer {
    protected final IIconContainer mIconContainer;
    private final short[] mRGBa;
    private final boolean glow;
    private final boolean stdOrient;
    private final boolean useExtFacing;
    private static final int NORMAL = 0;
    private static final int CLOCKWISE = 1;
    private static final int COUNTER_CLOCKWISE = 2;
    private static final int UPSIDE_DOWN = 3;

    protected GTRenderedTexture(IIconContainer aIcon, short[] aRGBa, boolean glow, boolean stdOrient, boolean extFacing) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GTRenderedTexture");
        }
        this.mIconContainer = aIcon;
        this.mRGBa = aRGBa;
        this.glow = glow;
        this.stdOrient = stdOrient;
        this.useExtFacing = extFacing;
    }

    @Override
    public void renderXPos(ISBRContext ctx) {
        IIcon overlayIcon;
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 1.0f, 0.0f, 0.0f);
        ctx.reset();
        boolean enableAO = renderBlocks.field_147863_w;
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(renderBlocks);
                return;
            }
            renderBlocks.field_147863_w = false;
            ctx.setLightnessOverride(1.0f);
            ctx.setBrightnessOverride(0xF000F0);
        }
        ExtendedFacing rotation = this.getExtendedFacing(ctx.getX(), ctx.getY(), ctx.getZ());
        if (ctx.canRenderInPass(this.mIconContainer::canRenderInPass)) {
            ctx.setupColor(ForgeDirection.EAST, this.mRGBa);
            this.renderFaceXPos(ctx, this.mIconContainer.getIcon(), rotation);
        }
        if ((overlayIcon = this.mIconContainer.getOverlayIcon()) != null && ctx.canRenderInPass(pass -> pass == 1)) {
            ctx.setupColor(ForgeDirection.EAST, 0xFFFFFF);
            this.renderFaceXPos(ctx, overlayIcon, rotation);
        }
        renderBlocks.field_147863_w = enableAO;
        this.draw(renderBlocks);
    }

    @Override
    public void renderXNeg(ISBRContext ctx) {
        IIcon overlayIcon;
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, -1.0f, 0.0f, 0.0f);
        ctx.reset();
        boolean enableAO = renderBlocks.field_147863_w;
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(renderBlocks);
                return;
            }
            renderBlocks.field_147863_w = false;
            ctx.setLightnessOverride(1.0f);
            ctx.setBrightnessOverride(0xF000F0);
        }
        ExtendedFacing rotation = this.getExtendedFacing(ctx.getX(), ctx.getY(), ctx.getZ());
        if (ctx.canRenderInPass(this.mIconContainer::canRenderInPass)) {
            ctx.setupColor(ForgeDirection.WEST, this.mRGBa);
            this.renderFaceXNeg(ctx, this.mIconContainer.getIcon(), rotation);
        }
        if ((overlayIcon = this.mIconContainer.getOverlayIcon()) != null && ctx.canRenderInPass(pass -> pass == 1)) {
            ctx.setupColor(ForgeDirection.WEST, 0xFFFFFF);
            this.renderFaceXNeg(ctx, overlayIcon, rotation);
        }
        renderBlocks.field_147863_w = enableAO;
        this.draw(renderBlocks);
    }

    @Override
    public void renderYPos(ISBRContext ctx) {
        IIcon overlayIcon;
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, 1.0f, 0.0f);
        ctx.reset();
        boolean enableAO = renderBlocks.field_147863_w;
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(renderBlocks);
                return;
            }
            renderBlocks.field_147863_w = false;
            ctx.setLightnessOverride(1.0f);
            ctx.setBrightnessOverride(0xF000F0);
        }
        ExtendedFacing rotation = this.getExtendedFacing(ctx.getX(), ctx.getY(), ctx.getZ());
        if (ctx.canRenderInPass(this.mIconContainer::canRenderInPass)) {
            ctx.setupColor(ForgeDirection.UP, this.mRGBa);
            this.renderFaceYPos(ctx, this.mIconContainer.getIcon(), rotation);
        }
        if ((overlayIcon = this.mIconContainer.getOverlayIcon()) != null && ctx.canRenderInPass(pass -> pass == 1)) {
            ctx.setupColor(ForgeDirection.UP, 0xFFFFFF);
            this.renderFaceYPos(ctx, overlayIcon, rotation);
        }
        renderBlocks.field_147863_w = enableAO;
        this.draw(renderBlocks);
    }

    @Override
    public void renderYNeg(ISBRContext ctx) {
        IIcon overlayIcon;
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, -1.0f, 0.0f);
        ctx.reset();
        boolean enableAO = renderBlocks.field_147863_w;
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(renderBlocks);
                return;
            }
            renderBlocks.field_147863_w = false;
            ctx.setLightnessOverride(1.0f);
            ctx.setBrightnessOverride(0xF000F0);
        }
        ExtendedFacing rotation = this.getExtendedFacing(ctx.getX(), ctx.getY(), ctx.getZ());
        if (ctx.canRenderInPass(this.mIconContainer::canRenderInPass)) {
            ctx.setupColor(ForgeDirection.DOWN, this.mRGBa);
            this.renderFaceYNeg(ctx, this.mIconContainer.getIcon(), rotation);
        }
        if ((overlayIcon = this.mIconContainer.getOverlayIcon()) != null && ctx.canRenderInPass(pass -> pass == 1)) {
            ctx.setupColor(ForgeDirection.DOWN, 0xFFFFFF);
            this.renderFaceYNeg(ctx, overlayIcon, rotation);
        }
        renderBlocks.field_147863_w = enableAO;
        this.draw(renderBlocks);
    }

    @Override
    public void renderZPos(ISBRContext ctx) {
        IIcon overlayIcon;
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, 0.0f, 1.0f);
        ctx.reset();
        boolean enableAO = renderBlocks.field_147863_w;
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(renderBlocks);
                return;
            }
            renderBlocks.field_147863_w = false;
            ctx.setLightnessOverride(1.0f);
            ctx.setBrightnessOverride(0xF000F0);
        }
        ExtendedFacing rotation = this.getExtendedFacing(ctx.getX(), ctx.getY(), ctx.getZ());
        if (ctx.canRenderInPass(this.mIconContainer::canRenderInPass)) {
            ctx.setupColor(ForgeDirection.SOUTH, this.mRGBa);
            this.renderFaceZPos(ctx, this.mIconContainer.getIcon(), rotation);
        }
        if ((overlayIcon = this.mIconContainer.getOverlayIcon()) != null && ctx.canRenderInPass(pass -> pass == 1)) {
            ctx.setupColor(ForgeDirection.SOUTH, 0xFFFFFF);
            this.renderFaceZPos(ctx, overlayIcon, rotation);
        }
        renderBlocks.field_147863_w = enableAO;
        this.draw(renderBlocks);
    }

    @Override
    public void renderZNeg(ISBRContext ctx) {
        IIcon overlayIcon;
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, 0.0f, -1.0f);
        ctx.reset();
        boolean enableAO = renderBlocks.field_147863_w;
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(renderBlocks);
                return;
            }
            renderBlocks.field_147863_w = false;
            ctx.setLightnessOverride(1.0f);
            ctx.setBrightnessOverride(0xF000F0);
        }
        ExtendedFacing rotation = this.getExtendedFacing(ctx.getX(), ctx.getY(), ctx.getZ());
        if (ctx.canRenderInPass(this.mIconContainer::canRenderInPass)) {
            ctx.setupColor(ForgeDirection.NORTH, this.mRGBa);
            this.renderFaceZNeg(ctx, this.mIconContainer.getIcon(), rotation);
        }
        if ((overlayIcon = this.mIconContainer.getOverlayIcon()) != null && ctx.canRenderInPass(pass -> pass == 1)) {
            ctx.setupColor(ForgeDirection.NORTH, 0xFFFFFF);
            this.renderFaceZNeg(ctx, overlayIcon, rotation);
        }
        renderBlocks.field_147863_w = enableAO;
        this.draw(renderBlocks);
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }

    protected void renderFaceYNeg(ISBRContext ctx, IIcon icon, ExtendedFacing extendedFacing) {
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        renderBlocks.field_147865_v = this.getRotation(extendedFacing);
        icon = this.getFlipped(ForgeDirection.DOWN, extendedFacing, icon);
        renderBlocks.func_147768_a(Blocks.field_150350_a, (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), icon);
        renderBlocks.field_147865_v = 0;
    }

    protected void renderFaceYPos(ISBRContext ctx, IIcon icon, ExtendedFacing extendedFacing) {
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        renderBlocks.field_147867_u = this.getRotation(extendedFacing);
        icon = this.getFlipped(ForgeDirection.UP, extendedFacing, icon);
        renderBlocks.func_147806_b(Blocks.field_150350_a, (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), icon);
        renderBlocks.field_147867_u = 0;
    }

    protected void renderFaceZNeg(ISBRContext ctx, IIcon icon, ExtendedFacing extendedFacing) {
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        renderBlocks.field_147875_q = this.getRotation(extendedFacing);
        renderBlocks.field_152631_f = true;
        icon = this.getFlipped(ForgeDirection.NORTH, extendedFacing, icon);
        renderBlocks.func_147761_c(Blocks.field_150350_a, (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), icon);
        renderBlocks.field_147875_q = 0;
        renderBlocks.field_152631_f = false;
    }

    protected void renderFaceZPos(ISBRContext ctx, IIcon icon, ExtendedFacing extendedFacing) {
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        renderBlocks.field_147873_r = this.getRotation(extendedFacing);
        icon = this.getFlipped(ForgeDirection.SOUTH, extendedFacing, icon);
        renderBlocks.func_147734_d(Blocks.field_150350_a, (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), icon);
        renderBlocks.field_147873_r = 0;
    }

    protected void renderFaceXNeg(ISBRContext ctx, IIcon icon, ExtendedFacing extendedFacing) {
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        renderBlocks.field_147869_t = this.getRotation(extendedFacing);
        icon = this.getFlipped(ForgeDirection.WEST, extendedFacing, icon);
        renderBlocks.func_147798_e(Blocks.field_150350_a, (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), icon);
        renderBlocks.field_147869_t = 0;
    }

    protected void renderFaceXPos(ISBRContext ctx, IIcon icon, ExtendedFacing extendedFacing) {
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        renderBlocks.field_147871_s = this.getRotation(extendedFacing);
        renderBlocks.field_152631_f = true;
        icon = this.getFlipped(ForgeDirection.EAST, extendedFacing, icon);
        renderBlocks.func_147764_f(Blocks.field_150350_a, (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), icon);
        renderBlocks.field_147871_s = 0;
        renderBlocks.field_152631_f = false;
    }

    private int getRotation(ExtendedFacing extendedFacing) {
        int n;
        if (extendedFacing == null) {
            return 0;
        }
        switch (extendedFacing.getRotation()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NORMAL: {
                n = 0;
                break;
            }
            case CLOCKWISE: {
                n = 1;
                break;
            }
            case UPSIDE_DOWN: {
                n = 3;
                break;
            }
            case COUNTER_CLOCKWISE: {
                n = 2;
            }
        }
        return n;
    }

    private IIcon getFlipped(ForgeDirection side, ExtendedFacing extendedFacing, IIcon icon) {
        boolean flipU = false;
        boolean flipV = false;
        if (extendedFacing == null) {
            if (side == ForgeDirection.EAST || side == ForgeDirection.DOWN) {
                flipU = true;
            }
            if (side == ForgeDirection.NORTH) {
                flipV = true;
            }
            return new GTIconFlipped(icon, flipU, flipV);
        }
        if (extendedFacing.getRotation().getIndex() % 2 == 0) {
            flipU = extendedFacing.getFlip().isHorizontallyFlipped();
        } else {
            flipV = extendedFacing.getFlip().isHorizontallyFlipped();
            if (side == ForgeDirection.EAST || side == ForgeDirection.NORTH) {
                flipU = true;
            }
        }
        if (side == ForgeDirection.DOWN) {
            flipU ^= true;
        }
        return new GTIconFlipped(icon, flipU, flipV);
    }

    private ExtendedFacing getExtendedFacing(int x, int y, int z) {
        if (this.stdOrient || !this.useExtFacing) {
            return ExtendedFacing.DEFAULT;
        }
        EntityPlayer player = GTMod.proxy.getThePlayer();
        if (player == null) {
            return ExtendedFacing.DEFAULT;
        }
        World w = player.func_130014_f_();
        if (w == null) {
            return ExtendedFacing.DEFAULT;
        }
        TileEntity te = w.func_147438_o(x, y, z);
        IAlignment alignment = null;
        if (te instanceof IGregTechTileEntity) {
            IMetaTileEntity meta = ((IGregTechTileEntity)te).getMetaTileEntity();
            if (meta instanceof IAlignmentProvider) {
                alignment = ((IAlignmentProvider)meta).getAlignment();
            }
        } else if (te instanceof IAlignmentProvider) {
            alignment = ((IAlignmentProvider)te).getAlignment();
        }
        if (alignment != null) {
            return alignment.getExtendedFacing();
        }
        return null;
    }
}

