/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui.widget;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.modularui.ICoverDataFollowerWidget;
import gregtech.common.covers.Cover;
import gregtech.common.gui.modularui.widget.CoverCycleButtonWidget;
import java.util.function.Consumer;
import java.util.function.Function;

public class CoverDataFollowerToggleButtonWidget<T extends Cover>
extends CoverCycleButtonWidget
implements ICoverDataFollowerWidget<T, Boolean> {
    private Function<T, Boolean> dataToStateGetter;

    public CoverDataFollowerToggleButtonWidget() {
        this.setGetter(() -> 0);
        this.setSynced(false, false);
        this.setLength(2);
    }

    public CoverDataFollowerToggleButtonWidget<T> setDataToStateGetter(Function<T, Boolean> dataToStateGetter) {
        this.dataToStateGetter = dataToStateGetter;
        return this;
    }

    public CoverDataFollowerToggleButtonWidget<T> setStateSetter(Consumer<Boolean> setter) {
        super.setSetter(val -> setter.accept(val == 1));
        return this;
    }

    @Override
    public void updateState(T data) {
        this.setState(this.dataToStateGetter.apply(data) != false ? 1 : 0, false, false);
    }

    public CoverDataFollowerToggleButtonWidget<T> setToggleTexture(IDrawable active, IDrawable inactive) {
        this.setTextureGetter(state -> state == 1 ? active : inactive);
        return this;
    }

    public static <T extends Cover> CoverDataFollowerToggleButtonWidget<T> ofCheckAndCross() {
        return new CoverDataFollowerToggleButtonWidget<T>().setToggleTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_CHECKMARK, (IDrawable)GTUITextures.OVERLAY_BUTTON_CROSS);
    }

    public static <T extends Cover> CoverDataFollowerToggleButtonWidget<T> ofCheck() {
        return new CoverDataFollowerToggleButtonWidget<T>().setToggleTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_CHECKMARK, (IDrawable)GTUITextures.TRANSPARENT);
    }

    public static <T extends Cover> CoverDataFollowerToggleButtonWidget<T> ofRedstone() {
        return new CoverDataFollowerToggleButtonWidget<T>().setToggleTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_REDSTONE_ON, (IDrawable)GTUITextures.OVERLAY_BUTTON_REDSTONE_OFF);
    }

    public static <T extends Cover> CoverDataFollowerToggleButtonWidget<T> ofDisableable() {
        return new CoverDataFollower_DisableableToggleButtonWidget();
    }

    public static class CoverDataFollower_DisableableToggleButtonWidget<T extends Cover>
    extends CoverDataFollowerToggleButtonWidget<T> {
        @Override
        protected boolean canClick() {
            return this.getState() == 0;
        }

        @Override
        public IDrawable[] getBackground() {
            if (!this.canClick()) {
                return new IDrawable[]{GTUITextures.BUTTON_COVER_NORMAL_DISABLED};
            }
            return super.getBackground();
        }
    }
}

