/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.util.FieldsAreNonnullByDefault;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public final class RecipeMapBackendProperties {
    public final int minItemInputs;
    public final int minFluidInputs;
    public final boolean specialSlotSensitive;
    public final Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> recipeEmitter;
    @Nullable
    private Consumer<? super GTRecipeBuilder> builderTransformer;
    @Nullable
    private Consumer<? super GTRecipe> recipeTransformer;

    static RecipeMapBackendPropertiesBuilder builder() {
        return new RecipeMapBackendPropertiesBuilder();
    }

    RecipeMapBackendProperties(int minItemInputs, int minFluidInputs, boolean specialSlotSensitive, Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> recipeEmitter, @Nullable Consumer<? super GTRecipeBuilder> builderTransformer, @Nullable Consumer<? super GTRecipe> recipeTransformer) {
        if (minItemInputs < 0 || minFluidInputs < 0) {
            throw new IllegalArgumentException("minItemInputs and minFluidInputs cannot be negative");
        }
        this.minItemInputs = minItemInputs;
        this.minFluidInputs = minFluidInputs;
        this.specialSlotSensitive = specialSlotSensitive;
        this.recipeEmitter = recipeEmitter;
        this.builderTransformer = builderTransformer;
        this.recipeTransformer = recipeTransformer;
    }

    public void appendBuilderTransformer(Consumer<? super GTRecipeBuilder> builderTransformer) {
        if (this.builderTransformer == null) {
            this.builderTransformer = builderTransformer;
        } else {
            Consumer<? super GTRecipeBuilder> t = this.builderTransformer;
            this.builderTransformer = b -> {
                t.accept((GTRecipeBuilder)b);
                builderTransformer.accept((GTRecipeBuilder)b);
            };
        }
    }

    public void appendRecipeTransformer(Consumer<? super GTRecipe> recipeTransformer) {
        if (this.recipeTransformer == null) {
            this.recipeTransformer = recipeTransformer;
        } else {
            Consumer<? super GTRecipe> t = this.recipeTransformer;
            this.recipeTransformer = r -> {
                t.accept((GTRecipe)r);
                recipeTransformer.accept((GTRecipe)r);
            };
        }
    }

    public void transformBuilder(GTRecipeBuilder builder) {
        if (this.builderTransformer != null) {
            this.builderTransformer.accept(builder);
        }
    }

    public void transformRecipe(GTRecipe recipe) {
        if (this.recipeTransformer != null) {
            this.recipeTransformer.accept(recipe);
        }
    }
}

