/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourSprayColorInfinite;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.IBlockAccess;

public class GTPacketInfiniteSpraycan
extends GTPacket {
    private Action action;
    private int newColor;
    private EntityPlayerMP player;

    public GTPacketInfiniteSpraycan() {
    }

    public GTPacketInfiniteSpraycan(Action action) {
        this.action = action;
        this.newColor = -1;
    }

    public GTPacketInfiniteSpraycan(Action action, int newColor) {
        this.action = action;
        this.newColor = newColor;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.INFINITE_SPRAYCAN.id;
    }

    @Override
    public void encode(ByteBuf aOut) {
        byte[] name = this.action.name().getBytes(StandardCharsets.UTF_8);
        aOut.writeInt(this.newColor);
        aOut.writeInt(name.length);
        aOut.writeBytes(name);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput aData) {
        int newColor = aData.readInt();
        int length = aData.readInt();
        byte[] name = new byte[length];
        aData.readFully(name, 0, length);
        return new GTPacketInfiniteSpraycan(Action.valueOf(new String(name, StandardCharsets.UTF_8)), newColor);
    }

    @Override
    public void setINetHandler(INetHandler aHandler) {
        this.player = ((NetHandlerPlayServer)aHandler).field_147369_b;
    }

    @Override
    public void process(IBlockAccess aWorld) {
        Item item;
        ItemStack currentItemStack = this.player.field_71071_by.func_70448_g();
        if (currentItemStack != null && (item = currentItemStack.func_77973_b()) instanceof MetaBaseItem) {
            MetaBaseItem item2 = (MetaBaseItem)item;
            item2.forEachBehavior(currentItemStack, behavior -> {
                BehaviourSprayColorInfinite spraycanBehavior;
                return behavior instanceof BehaviourSprayColorInfinite && this.action.execute(spraycanBehavior = (BehaviourSprayColorInfinite)behavior, currentItemStack, this.player, this.newColor);
            });
        }
    }

    public static enum Action {
        INCREMENT_COLOR{

            @Override
            boolean execute(BehaviourSprayColorInfinite behaviour, ItemStack itemStack, EntityPlayerMP player, int newColor) {
                if (!behaviour.isLocked(itemStack)) {
                    behaviour.incrementColor(itemStack, player.func_70093_af());
                    Action.playShakeSound(player);
                    return true;
                }
                return false;
            }
        }
        ,
        LOCK_CAN{

            @Override
            boolean execute(BehaviourSprayColorInfinite behavior, ItemStack itemStack, EntityPlayerMP player, int newColor) {
                if (behavior.toggleLock(itemStack)) {
                    Action.playLockSound(player);
                } else {
                    Action.playUnlockSound(player);
                }
                return true;
            }
        }
        ,
        SET_COLOR{

            @Override
            boolean execute(BehaviourSprayColorInfinite behavior, ItemStack itemStack, EntityPlayerMP player, int newColor) {
                if (newColor != -1) {
                    behavior.setColor(itemStack, (byte)newColor);
                    Action.playShakeSound(player);
                    return true;
                }
                return false;
            }
        }
        ,
        TOGGLE_SHAKE_LOCK{

            @Override
            boolean execute(BehaviourSprayColorInfinite behavior, ItemStack itemStack, EntityPlayerMP player, int newColor) {
                if (behavior.togglePreventShake(itemStack)) {
                    Action.playLockSound(player);
                } else {
                    Action.playUnlockSound(player);
                }
                return true;
            }
        };


        private static void playShakeSound(EntityPlayerMP player) {
            GTUtility.sendSoundToPlayers(player.field_70170_p, SoundResource.GT_SPRAYCAN_SHAKE, 1.0f, 1.0f, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }

        private static void playLockSound(EntityPlayerMP player) {
            GTUtility.sendSoundToPlayers(player.field_70170_p, SoundResource.GT_SPRAYCAN_LOCK, 1.0f, 1.0f, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }

        private static void playUnlockSound(EntityPlayerMP player) {
            GTUtility.sendSoundToPlayers(player.field_70170_p, SoundResource.GT_SPRAYCAN_UNLOCK, 1.0f, 1.0f, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }

        abstract boolean execute(BehaviourSprayColorInfinite var1, ItemStack var2, EntityPlayerMP var3, int var4);
    }
}

