/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.GTMod;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;

public class GTPacketCreateTE
extends GTPacket {
    private int mX;
    private int mZ;
    private int mC0;
    private int mC1;
    private int mC2;
    private int mC3;
    private int mC4;
    private int mC5;
    private short mY;
    private short mID;
    private byte mCommon;
    private byte mUpdate;
    private byte mRedstone;
    private byte mColor;
    private byte mType;
    public static final byte TYPE_META_TILE = 0;
    public static final byte TYPE_META_PIPE = 1;

    public GTPacketCreateTE() {
    }

    public GTPacketCreateTE(int aX, short aY, int aZ, short aID, int aC0, int aC1, int aC2, int aC3, int aC4, int aC5, byte aCommon, byte aUpdate, byte aRedstone, byte aColor, byte aType) {
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
        this.mC0 = aC0;
        this.mC1 = aC1;
        this.mC2 = aC2;
        this.mC3 = aC3;
        this.mC4 = aC4;
        this.mC5 = aC5;
        this.mID = aID;
        this.mCommon = aCommon;
        this.mUpdate = aUpdate;
        this.mRedstone = aRedstone;
        this.mColor = aColor;
        this.mType = aType;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.CREATE_TILE_ENTITY.id;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeShort((int)this.mID);
        aOut.writeInt(this.mC0);
        aOut.writeInt(this.mC1);
        aOut.writeInt(this.mC2);
        aOut.writeInt(this.mC3);
        aOut.writeInt(this.mC4);
        aOut.writeInt(this.mC5);
        aOut.writeByte((int)this.mCommon);
        aOut.writeByte((int)this.mUpdate);
        aOut.writeByte((int)this.mRedstone);
        aOut.writeByte((int)this.mColor);
        aOut.writeByte((int)this.mType);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput aData) {
        return new GTPacketCreateTE(aData.readInt(), aData.readShort(), aData.readInt(), aData.readShort(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readByte(), aData.readByte(), aData.readByte(), aData.readByte(), aData.readByte());
    }

    @Override
    public void process(IBlockAccess world) {
        if (world == null) {
            return;
        }
        if (world instanceof WorldClient) {
            TileEntity tileEntity = world.func_147438_o(this.mX, (int)this.mY, this.mZ);
            if (tileEntity == null) {
                try {
                    switch (this.mType) {
                        case 0: {
                            BaseMetaTileEntity newTileEntity = this.getBaseMetaTileEntity();
                            ((WorldClient)world).func_147455_a(this.mX, (int)this.mY, this.mZ, (TileEntity)newTileEntity);
                            break;
                        }
                        case 1: {
                            BaseMetaPipeEntity newTileEntity = this.getBaseMetaPipeEntity();
                            ((WorldClient)world).func_147455_a(this.mX, (int)this.mY, this.mZ, (TileEntity)newTileEntity);
                        }
                    }
                }
                catch (Exception e) {
                    GTMod.GT_FML_LOGGER.error("Exception creating Tile Entity at ({}, {}, {})", new Object[]{this.mX, this.mY, this.mZ});
                }
            } else {
                try {
                    if (tileEntity instanceof BaseMetaTileEntity) {
                        BaseMetaTileEntity tile = (BaseMetaTileEntity)tileEntity;
                        tile.receiveMetaTileEntityData(this.mID, this.mC0, this.mC1, this.mC2, this.mC3, this.mC4, this.mC5, this.mCommon, this.mUpdate, this.mRedstone, this.mColor);
                    } else if (tileEntity instanceof BaseMetaPipeEntity) {
                        BaseMetaPipeEntity pipe = (BaseMetaPipeEntity)tileEntity;
                        pipe.receiveMetaTileEntityData(this.mID, this.mC0, this.mC1, this.mC2, this.mC3, this.mC4, this.mC5, this.mCommon, this.mUpdate, this.mRedstone, this.mColor);
                    }
                }
                catch (Exception e) {
                    GTMod.GT_FML_LOGGER.error("Exception setting tile entity data for tile entity {} at ({}, {}, {})", new Object[]{tileEntity, this.mX, this.mY, this.mZ});
                }
            }
        }
    }

    @NotNull
    private BaseMetaPipeEntity getBaseMetaPipeEntity() {
        BaseMetaPipeEntity newTileEntity = new BaseMetaPipeEntity();
        newTileEntity.receiveMetaTileEntityData(this.mID, this.mC0, this.mC1, this.mC2, this.mC3, this.mC4, this.mC5, this.mCommon, this.mUpdate, this.mRedstone, this.mColor);
        return newTileEntity;
    }

    @NotNull
    private BaseMetaTileEntity getBaseMetaTileEntity() {
        BaseMetaTileEntity newTileEntity = new BaseMetaTileEntity();
        newTileEntity.receiveMetaTileEntityData(this.mID, this.mC0, this.mC1, this.mC2, this.mC3, this.mC4, this.mC5, this.mCommon, this.mUpdate, this.mRedstone, this.mColor);
        return newTileEntity;
    }
}

