/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import codechicken.nei.api.API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.HarvestTool;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.ITemporaryTE;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEFrame
extends MetaPipeEntity
implements ITemporaryTE {
    private static final String localizedDescFormat = GTLanguageManager.addStringLocalization("gt.blockmachines.gt_frame.desc.format", "Just something you can put covers on.");
    public final Materials mMaterial;

    public MTEFrame(int aID, String aName, String aNameRegional, Materials aMaterial) {
        super(aID, aName, aNameRegional, 0);
        this.mMaterial = aMaterial;
        API.hideItem((ItemStack)this.getStackForm(1L));
    }

    public MTEFrame(String aName, Materials aMaterial) {
        super(aName, 0);
        this.mMaterial = aMaterial;
    }

    @Override
    public byte getTileEntityBaseType() {
        HarvestTool harvestTool;
        int level = this.mMaterial == null ? 0 : GTUtility.clamp(this.mMaterial.mToolQuality, 0, 3);
        switch (level) {
            case 0: {
                harvestTool = HarvestTool.WrenchPipeLevel0;
                break;
            }
            case 1: {
                harvestTool = HarvestTool.WrenchPipeLevel1;
                break;
            }
            case 2: {
                harvestTool = HarvestTool.WrenchPipeLevel2;
                break;
            }
            case 3: {
                harvestTool = HarvestTool.WrenchPipeLevel3;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected tool quality level: " + level);
            }
        }
        HarvestTool tool = harvestTool;
        return tool.toTileEntityBaseType();
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEFrame(this.mName, this.mMaterial);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, int connections, int colorIndex, boolean active, boolean redstoneLevel) {
        return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[OrePrefixes.frameGt.mTextureIndex], Dyes.getModulation(colorIndex, this.mMaterial.mRGBa))};
    }

    @Override
    public String[] getDescription() {
        return localizedDescFormat.split("\\R");
    }

    @Override
    public final boolean isFacingValid(ForgeDirection facing) {
        return false;
    }

    @Override
    public final boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public final boolean renderInside(ForgeDirection side) {
        return true;
    }

    @Override
    public final float getThickness() {
        return 1.0f;
    }

    @Override
    public float getCollisionThickness() {
        return 1.0f;
    }

    @Override
    public final void saveNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public final void loadNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public final boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public final boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public int connect(ForgeDirection side) {
        return 0;
    }

    @Override
    public void disconnect(ForgeDirection side) {
    }

    @Override
    public boolean isMachineBlockUpdateRecursive() {
        return true;
    }
}

