/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.GTMetaTileEntity;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import crazypants.enderio.Log;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.modularui2.GTGuiTextures;
import gregtech.api.modularui2.GTGuis;
import gregtech.api.render.TextureFactory;
import gregtech.common.gui.modularui.widget.CoverCycleButtonWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTENeutronSensor
extends MTEHatch {
    private static final IIconContainer textureFont = new Textures.BlockIcons.CustomIcon("icons/NeutronSensorFont");
    private static final IIconContainer textureFont_Glow = new Textures.BlockIcons.CustomIcon("icons/NeutronSensorFont_GLOW");
    protected int threshold = 0;
    protected boolean inverted = false;
    boolean isOn = false;

    public MTENeutronSensor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "Detect Neutron Kinetic Energy.", new ITexture[0]);
    }

    public MTENeutronSensor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Can be installed in Neutron Activator.", "Output Redstone Signal according to the Neutron Kinetic Energy.", "Right click to open the GUI and setting."};
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mBoxContext")) {
            this.setThresholdFromString(aNBT.func_74779_i("mBoxContext"));
        } else {
            this.threshold = aNBT.func_74762_e("mThreshold");
            this.inverted = aNBT.func_74767_n("mInverted");
        }
        super.loadNBTData(aNBT);
    }

    private void setThresholdFromString(String text) {
        Matcher matcher = Pattern.compile("^(<|>|<=|>=|==|!=)([0-9]*)(|k|m)(ev)$", 2).matcher(text);
        if (!matcher.matches()) {
            Log.error((String)("Failed to parse Neutron Sensor setting: \"" + text + "\"!"));
            return;
        }
        String operator = matcher.group(1);
        String value = matcher.group(2);
        String suffix = matcher.group(3);
        int newThreshold = Integer.parseInt(value);
        switch (suffix) {
            case "k": 
            case "K": {
                newThreshold *= 1000;
                break;
            }
            case "m": 
            case "M": {
                newThreshold *= 1000000;
            }
        }
        switch (operator) {
            case "<": {
                this.threshold = newThreshold;
                this.inverted = true;
                break;
            }
            case ">": 
            case "!=": {
                this.threshold = newThreshold + 1;
                this.inverted = false;
                break;
            }
            case "<=": 
            case "==": {
                this.threshold = newThreshold + 1;
                this.inverted = true;
                break;
            }
            case ">=": {
                this.threshold = newThreshold;
                this.inverted = false;
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mThreshold", this.threshold);
        aNBT.func_74757_a("mInverted", this.inverted);
        super.saveNBTData(aNBT);
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        this.getBaseMetaTileEntity().setActive(true);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        this.openGui(aPlayer);
        return true;
    }

    public void updateRedstoneOutput(int eV) {
        this.isOn = eV >= this.threshold ^ this.inverted;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(textureFont), TextureFactory.builder().addIcon(textureFont_Glow).glow().build()};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(textureFont)};
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.isOn) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                aBaseMetaTileEntity.setInternalOutputRedstoneSignal(side, (byte)15);
            }
        } else {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                aBaseMetaTileEntity.setInternalOutputRedstoneSignal(side, (byte)0);
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENeutronSensor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection Side2, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    protected boolean useMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData data, PanelSyncManager syncManager, UISettings uiSettings) {
        return (ModularPanel)GTGuis.mteTemplatePanelBuilder(this, data, syncManager, uiSettings).build().child((IWidget)((Flow)((Flow)((Flow)Flow.column().child((IWidget)this.createInvertButtonRow())).child((IWidget)this.createThresholdFieldRow())).coverChildren()).crossAxisAlignment(Alignment.CrossAxis.START).childPadding(2).pos(8, 6));
    }

    public Flow createInvertButtonRow() {
        BooleanSyncValue invertedSyncer = new BooleanSyncValue(() -> this.inverted, val -> {
            this.inverted = val;
        });
        return ((Flow)((Flow)((Flow)Flow.row().child((IWidget)new ToggleButton().value((IBoolValue)invertedSyncer).overlay(true, new IDrawable[]{GTGuiTextures.OVERLAY_BUTTON_REDSTONE_ON}).overlay(false, new IDrawable[]{GTGuiTextures.OVERLAY_BUTTON_REDSTONE_OFF}).size(16, 16))).child((IWidget)IKey.dynamic(() -> invertedSyncer.getValue() != false ? StatCollector.func_74838_a((String)"gt.interact.desc.inverted") : StatCollector.func_74838_a((String)"gt.interact.desc.normal")).asWidget())).coverChildren()).childPadding(2);
    }

    public Flow createThresholdFieldRow() {
        return ((Flow)((Flow)((Flow)Flow.row().child((IWidget)((TextFieldWidget)new TextFieldWidget().setFormatAsInteger(true).setNumbers(0, 1200000000).size(77, 12)).value((IStringValue)new IntSyncValue(() -> this.threshold, val -> {
            this.threshold = val;
        })).setFocusOnGuiOpen(true))).child((IWidget)IKey.lang((String)"gui.NeutronSensor.4").asWidget())).coverChildren()).childPadding(2);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverCycleButtonWidget().setToggle(() -> this.inverted, val -> {
            this.inverted = val;
        }).setTextureGetter(state -> state == 1 ? GTUITextures.OVERLAY_BUTTON_REDSTONE_ON : GTUITextures.OVERLAY_BUTTON_REDSTONE_OFF).addTooltip(0, StatCollector.func_74838_a((String)"gt.interact.desc.normal")).addTooltip(1, StatCollector.func_74838_a((String)"gt.interact.desc.inverted")).setPos(10, 8))).widget(new TextWidget().setStringSupplier(() -> this.inverted ? StatCollector.func_74838_a((String)"gt.interact.desc.inverted") : StatCollector.func_74838_a((String)"gt.interact.desc.normal")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setTextAlignment(Alignment.CenterLeft).setPos(28, 12))).widget(new NumericWidget().setBounds(0.0, 1.2E9).setGetter(() -> this.threshold).setSetter(value -> {
            this.threshold = (int)value;
        }).setScrollValues(1000.0, 1.0, 1000000.0).setTextColor(Color.WHITE.dark(1)).setTextAlignment(Alignment.CenterLeft).setFocusOnGuiOpen(true).setBackground(new com.gtnewhorizons.modularui.api.drawable.IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(10, 28).setSize(77, 12))).widget(new TextWidget(StatCollector.func_74838_a((String)"gui.NeutronSensor.4")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setTextAlignment(Alignment.CenterLeft).setPos(90, 30));
    }
}

