/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg.registry;

import galacticgreg.GalacticGreg;
import galacticgreg.api.Enums;
import galacticgreg.api.ModContainer;
import galacticgreg.api.ModDimensionDef;
import galacticgreg.dynconfig.DynamicDimensionConfig;
import galacticgreg.generators.GenEllipsoid;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.chunk.IChunkProvider;

public class GalacticGregRegistry {
    private static final Map<String, ModContainer> modContainers = new HashMap<String, ModContainer>();
    private static boolean initializationDone = false;

    public static void registerModContainer(ModContainer modContainer) {
        if (initializationDone) {
            GalacticGreg.Logger.warn("Initialization is already done, you can't add more ModContainers!", new Object[0]);
            return;
        }
        if (modContainers.containsKey(modContainer.getModName())) {
            GalacticGreg.Logger.warn("There is already a mod registered with that name: [%s]", modContainer.getModName());
            return;
        }
        GalacticGreg.Logger.info("Registered new mod to generate ores: [%s] Dimensions provided: [%d]", modContainer.getModName(), modContainer.getDimensionList().size());
        modContainers.put(modContainer.getModName(), modContainer);
    }

    public static ModDimensionDef getDimensionTypeByChunkGenerator(IChunkProvider chunkProvider) {
        try {
            if (!initializationDone) {
                return null;
            }
            String tFQCPN = chunkProvider.toString().split("@")[0];
            ModDimensionDef tReturnMDD = null;
            block2: for (ModContainer mc : modContainers.values()) {
                for (ModDimensionDef mdd : mc.getDimensionList()) {
                    if (!mdd.getChunkProviderName().equals(tFQCPN)) continue;
                    tReturnMDD = mdd;
                    continue block2;
                }
            }
            return tReturnMDD;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Collection<ModContainer> getModContainers() {
        if (!initializationDone) {
            return null;
        }
        return modContainers.values();
    }

    public static boolean InitRegistry() {
        if (initializationDone) {
            return false;
        }
        GalacticGregRegistry.InitModContainers();
        DynamicDimensionConfig.InitDynamicConfig();
        return true;
    }

    private static void InitModContainers() {
        for (ModContainer mc : modContainers.values()) {
            if (!mc.isModLoaded()) {
                GalacticGreg.Logger.warn("Ignoring ModRegistration for OreGen: [%s], because mod is not loaded. Did you misspell the name?", mc.getModName());
                continue;
            }
            GalacticGreg.Logger.info("Mod [%s] is now enabled for OreGen by GalacticGreg", mc.getModName());
            for (ModDimensionDef md : mc.getDimensionList()) {
                GalacticGreg.Logger.info("ModID: [%s] DimName: [%s] ValidBlocks: [%d] Identifier: [%s] Generators: [%d]", mc.getModName(), md.getDimensionName(), md.getReplaceableBlocks().size(), md.getDimIdentifier(), md.getSpaceObjectGenerators().size());
                if (md.getDimensionType() == Enums.DimensionType.Asteroid) {
                    if (md.getSpaceObjectGenerators().isEmpty()) {
                        GalacticGreg.Logger.debug("No generators found, adding built-in ellipsoid generator", new Object[0]);
                        md.registerSpaceObjectGenerator(new GenEllipsoid());
                    }
                    GalacticGreg.Logger.info("Asteroid-Enabled dimension. Registered Generators: [%d]", md.getSpaceObjectGenerators().size());
                }
                md.finalizeReplaceableBlocks(mc.getModName());
            }
        }
        initializationDone = true;
    }
}

