/*
 * Decompiled with CFR 0.152.
 */
package detrav.utils;

import gregtech.GTMod;
import gregtech.api.enums.UndergroundFluidNames;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidColors {
    private static boolean initialized;
    private static final HashMap<Integer, short[]> fluidColors;

    private static void generateFluidColors() {
        for (UndergroundFluidNames value : UndergroundFluidNames.values()) {
            Fluid fluid = FluidRegistry.getFluid((String)value.name);
            if (fluid != null) {
                if (value.renderColor != null) {
                    fluidColors.put(fluid.getID(), value.renderColor);
                    continue;
                }
                fluidColors.put(fluid.getID(), FluidColors.convertColorInt(fluid.getColor()));
                continue;
            }
            GTMod.GT_FML_LOGGER.error("[FluidColors] no registered fluid named " + value.name);
        }
    }

    private static short[] convertColorInt(int color) {
        return new short[]{(short)(color << 16 & 0xFF), (short)(color << 8 & 0xFF), (short)(color & 0xFF)};
    }

    @Nonnull
    public static short[] getColor(int fluidID) {
        short[] color;
        if (!initialized) {
            FluidColors.generateFluidColors();
            initialized = true;
        }
        if ((color = fluidColors.get(fluidID)) == null) {
            GTMod.GT_FML_LOGGER.error("Unknown fluid ID = " + fluidID + " This shouldn't happen!");
            return new short[]{0, 0, 0, 0};
        }
        return color;
    }

    static {
        fluidColors = new HashMap();
    }
}

