/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.net;

import bartworks.system.oredict.OreDictHandler;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacket;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Pair;

public class PacketOreDictCache
extends GTPacket {
    private HashSet<Pair<Integer, Short>> hashSet = new HashSet();

    public PacketOreDictCache() {
    }

    public PacketOreDictCache(HashSet<Pair<Integer, Short>> set) {
        this.hashSet = set;
    }

    @Override
    public byte getPacketID() {
        return 25;
    }

    @Override
    public void encode(ByteBuf aOut) {
        int size = this.hashSet.size();
        aOut.writeInt(size);
        for (Pair<Integer, Short> p : this.hashSet) {
            aOut.writeInt(((Integer)p.getKey()).intValue()).writeShort((int)((Short)p.getValue()).shortValue());
        }
    }

    @Override
    public GTPacket decode(ByteArrayDataInput byteArrayDataInput) {
        int size = byteArrayDataInput.readInt();
        for (int i = 0; i < size; ++i) {
            this.hashSet.add((Pair<Integer, Short>)Pair.of((Object)byteArrayDataInput.readInt(), (Object)byteArrayDataInput.readShort()));
        }
        return new PacketOreDictCache(this.hashSet);
    }

    @Override
    public void process(IBlockAccess iBlockAccess) {
        OreDictHandler.getNonBWCache().clear();
        OreDictHandler.getNonBWCache().addAll(this.hashSet);
    }
}

