/*
 * Decompiled with CFR 0.152.
 */
package vfyjxf.bettercrashes.mixins.early;

import cpw.mods.fml.common.ModContainer;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vfyjxf.bettercrashes.BetterCrashesConfig;
import vfyjxf.bettercrashes.mixins.interfaces.CrashReportExt;
import vfyjxf.bettercrashes.utils.ModIdentifier;
import vfyjxf.bettercrashes.utils.StacktraceDeobfuscator;

@Mixin(value={CrashReport.class}, priority=500)
public class CrashReportMixin
implements CrashReportExt {
    @Shadow
    @Final
    private CrashReportCategory field_85061_c;
    @Shadow
    @Final
    private Throwable field_71511_b;
    @Shadow
    @Final
    private List<CrashReportCategory> field_71512_c;
    @Shadow
    @Final
    private String field_71513_a;
    @Unique
    private Set<ModContainer> betterCrashes$suspectedMods;

    @Shadow
    private static String func_71503_h() {
        return null;
    }

    @Override
    public Set<ModContainer> betterCrashes$getSuspectedMods() {
        return this.betterCrashes$suspectedMods;
    }

    @Inject(method={"populateEnvironment"}, at={@At(value="HEAD")})
    private void betterCrashes$beforePopulateEnvironment(CallbackInfo ci) {
        if (BetterCrashesConfig.stacktraceDeobfuscation) {
            StacktraceDeobfuscator.init(new File(String.format("%s-stackdeobfuscator-methods.csv", "bettercrashes")));
        }
        StacktraceDeobfuscator.deobfuscateThrowable(this.field_71511_b);
    }

    @Inject(method={"populateEnvironment"}, at={@At(value="TAIL")})
    private void betterCrashes$afterPopulateEnvironment(CallbackInfo ci) {
        this.field_85061_c.func_71500_a("Suspected Mods", () -> {
            try {
                this.betterCrashes$suspectedMods = ModIdentifier.identifyFromStacktrace(this.field_71511_b);
                String modListString = "Unknown";
                ArrayList<String> modNames = new ArrayList<String>();
                for (ModContainer mod : this.betterCrashes$suspectedMods) {
                    modNames.add(mod.getName() + " (" + mod.getModId() + ")");
                }
                if (!modNames.isEmpty()) {
                    modListString = StringUtils.join(modNames, (String)", ");
                }
                return modListString;
            }
            catch (Throwable e) {
                return ExceptionUtils.getStackTrace((Throwable)e).replace("\t", "    ");
            }
        });
    }

    @Overwrite
    public String func_71502_e() {
        StringBuilder builder = new StringBuilder();
        builder.append("---- Minecraft Crash Report ----\n").append("// ").append(this.betterCrashes$getVanillaFixComment()).append("\n\n").append("Time: ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date())).append("\n").append("Description: ").append(this.field_71513_a).append("\n\n").append(CrashReportMixin.betterCrashes$stacktraceToString(this.field_71511_b).replace("\t", "    ")).append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i = 0; i < 87; ++i) {
            builder.append("-");
        }
        builder.append("\n\n");
        this.func_71506_a(builder);
        return builder.toString().replace("\t", "    ");
    }

    @Unique
    private static String betterCrashes$stacktraceToString(Throwable cause) {
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @Overwrite
    public void func_71506_a(StringBuilder builder) {
        for (CrashReportCategory crashreportcategory : this.field_71512_c) {
            crashreportcategory.func_85072_a(builder);
            builder.append("\n");
        }
        this.field_85061_c.func_85072_a(builder);
    }

    @Unique
    private String betterCrashes$getVanillaFixComment() {
        try {
            if (Math.random() < 0.01 && !this.betterCrashes$suspectedMods.isEmpty()) {
                ModContainer mod = this.betterCrashes$suspectedMods.iterator().next();
                String author = (String)mod.getMetadata().authorList.get(0);
                return "I blame " + author + ".";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return CrashReportMixin.func_71503_h();
    }
}

