/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.lang.reflect.Method;
import java.util.List;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyUtil {
    private static final boolean isRFLoaded = EnergyConfigHandler.isRFAPILoaded();
    private static final boolean isRF1Loaded = EnergyConfigHandler.isRFAPIv1Loaded();
    private static final boolean isRF2Loaded = EnergyConfigHandler.isRFAPIv2Loaded();
    private static final boolean isIC2Loaded = EnergyConfigHandler.isIndustrialCraft2Loaded();
    private static boolean isBCReallyLoaded = EnergyConfigHandler.isBuildcraftReallyLoaded();
    public static boolean voltageParameterIC2 = false;
    public static Method demandedEnergyIC2 = null;
    public static Method injectEnergyIC2 = null;
    public static Method offeredEnergyIC2 = null;
    public static Method drawEnergyIC2 = null;
    public static Class<?> clazzEnderIOCable = null;
    public static Class<?> clazzMFRRednetEnergyCable = null;
    public static Class<?> clazzRailcraftEngine = null;
    private static Class<?> clazzPipeTile = null;
    public static boolean initialisedIC2Methods = EnergyUtil.initialiseIC2Methods();

    public static TileEntity[] getAdjacentPowerConnections(TileEntity tile) {
        TileEntity[] adjacentConnections = new TileEntity[6];
        BlockVec3 thisVec = new BlockVec3(tile);
        World world = tile.func_145831_w();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(world, direction);
            if (tileEntity == null) continue;
            if (tileEntity instanceof IConnector) {
                if (!((IConnector)tileEntity).canConnect(direction.getOpposite(), NetworkType.POWER)) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isBCReallyLoaded && clazzPipeTile.isInstance(tileEntity)) continue;
            if (isIC2Loaded && tileEntity instanceof IEnergyTile) {
                if (tileEntity instanceof IEnergyConductor) continue;
                boolean doneIC2 = false;
                if (tileEntity instanceof IEnergyAcceptor) {
                    doneIC2 = true;
                    if (((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(tile, direction.getOpposite())) {
                        adjacentConnections[direction.ordinal()] = tileEntity;
                    }
                }
                if (tileEntity instanceof IEnergyEmitter) {
                    doneIC2 = true;
                    if (((IEnergyEmitter)tileEntity).emitsEnergyTo(tile, direction.getOpposite())) {
                        adjacentConnections[direction.ordinal()] = tileEntity;
                    }
                }
                if (doneIC2) continue;
            }
            if (!isRFLoaded || !(tileEntity instanceof IEnergyConnection) || (!isRF2Loaded || !(tileEntity instanceof IEnergyProvider) && !(tileEntity instanceof IEnergyReceiver)) && (!isRF1Loaded || !(tileEntity instanceof IEnergyHandler)) && (clazzRailcraftEngine == null || !clazzRailcraftEngine.isInstance(tileEntity)) || clazzEnderIOCable != null && clazzEnderIOCable.isInstance(tileEntity) || clazzMFRRednetEnergyCable != null && clazzMFRRednetEnergyCable.isInstance(tileEntity) || !((IEnergyConnection)tileEntity).canConnectEnergy(direction.getOpposite())) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }

    public static void setAdjacentPowerConnections(TileEntity conductor, List<TileEntity> acceptors, List<ForgeDirection> directions) throws Exception {
        BlockVec3 thisVec = new BlockVec3(conductor);
        World world = conductor.func_145831_w();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(world, direction);
            if (tileEntity == null || tileEntity instanceof IConductor) continue;
            ForgeDirection sideFrom = direction.getOpposite();
            if (tileEntity instanceof IElectrical) {
                if (!((IElectrical)tileEntity).canConnect(sideFrom, NetworkType.POWER)) continue;
                acceptors.add(tileEntity);
                directions.add(sideFrom);
                continue;
            }
            if (isBCReallyLoaded && clazzPipeTile.isInstance(tileEntity)) continue;
            if (isIC2Loaded && tileEntity instanceof IEnergyAcceptor) {
                if (tileEntity instanceof IEnergyConductor || !((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(conductor, sideFrom)) continue;
                acceptors.add(tileEntity);
                directions.add(sideFrom);
                continue;
            }
            if ((!isRF2Loaded || !(tileEntity instanceof IEnergyReceiver)) && (!isRF1Loaded || !(tileEntity instanceof IEnergyHandler)) || clazzEnderIOCable != null && clazzEnderIOCable.isInstance(tileEntity) || clazzMFRRednetEnergyCable != null && clazzMFRRednetEnergyCable.isInstance(tileEntity) || !((IEnergyConnection)tileEntity).canConnectEnergy(sideFrom)) continue;
            acceptors.add(tileEntity);
            directions.add(sideFrom);
        }
    }

    public static float otherModsEnergyTransfer(TileEntity tileAdj, ForgeDirection inputAdj, float toSend, boolean simulate) {
        if (isIC2Loaded && !EnergyConfigHandler.disableIC2Output && tileAdj instanceof IEnergySink) {
            double demanded;
            block11: {
                demanded = 0.0;
                try {
                    demanded = (Double)demandedEnergyIC2.invoke((Object)tileAdj, new Object[0]);
                }
                catch (Exception ex) {
                    if (!ConfigManagerCore.enableDebug) break block11;
                    ex.printStackTrace();
                }
            }
            if (simulate) {
                return Math.min(toSend, (float)demanded / EnergyConfigHandler.TO_IC2_RATIO);
            }
            double energySendingIC2 = Math.min((double)(toSend * EnergyConfigHandler.TO_IC2_RATIO), demanded);
            if (energySendingIC2 >= 1.0) {
                double result;
                block12: {
                    result = 0.0;
                    try {
                        result = voltageParameterIC2 ? energySendingIC2 - (Double)injectEnergyIC2.invoke((Object)tileAdj, inputAdj, energySendingIC2, 120.0) : energySendingIC2 - (Double)injectEnergyIC2.invoke((Object)tileAdj, inputAdj, energySendingIC2);
                    }
                    catch (Exception ex) {
                        if (!ConfigManagerCore.enableDebug) break block12;
                        ex.printStackTrace();
                    }
                }
                if (result < 0.0) {
                    return 0.0f;
                }
                return (float)result / EnergyConfigHandler.TO_IC2_RATIO;
            }
        } else {
            if (isRF1Loaded && !EnergyConfigHandler.disableRFOutput && tileAdj instanceof IEnergyHandler) {
                return (float)((IEnergyHandler)tileAdj).receiveEnergy(inputAdj, MathHelper.func_76141_d((float)(toSend * EnergyConfigHandler.TO_RF_RATIO)), simulate) / EnergyConfigHandler.TO_RF_RATIO;
            }
            if (isRF2Loaded && !EnergyConfigHandler.disableRFOutput && tileAdj instanceof IEnergyReceiver) {
                return (float)((IEnergyReceiver)tileAdj).receiveEnergy(inputAdj, MathHelper.func_76141_d((float)(toSend * EnergyConfigHandler.TO_RF_RATIO)), simulate) / EnergyConfigHandler.TO_RF_RATIO;
            }
        }
        return 0.0f;
    }

    public static float otherModsEnergyExtract(TileEntity tileAdj, ForgeDirection inputAdj, float toPull, boolean simulate) {
        if (isIC2Loaded && !EnergyConfigHandler.disableIC2Input && tileAdj instanceof IEnergySource) {
            double offered;
            block11: {
                offered = 0.0;
                try {
                    offered = (Double)offeredEnergyIC2.invoke((Object)tileAdj, new Object[0]);
                }
                catch (Exception ex) {
                    if (!ConfigManagerCore.enableDebug) break block11;
                    ex.printStackTrace();
                }
            }
            if (simulate) {
                return Math.min(toPull, (float)offered / EnergyConfigHandler.TO_IC2_RATIO);
            }
            double energySendingIC2 = Math.min((double)(toPull * EnergyConfigHandler.TO_IC2_RATIO), offered);
            if (energySendingIC2 >= 1.0) {
                double resultIC2;
                block12: {
                    resultIC2 = 0.0;
                    try {
                        resultIC2 = energySendingIC2 - (Double)drawEnergyIC2.invoke((Object)tileAdj, energySendingIC2);
                    }
                    catch (Exception ex) {
                        if (!ConfigManagerCore.enableDebug) break block12;
                        ex.printStackTrace();
                    }
                }
                if (resultIC2 < 0.0) {
                    resultIC2 = 0.0;
                }
                return (float)resultIC2 / EnergyConfigHandler.TO_IC2_RATIO;
            }
        } else {
            if (isRF2Loaded && !EnergyConfigHandler.disableRFInput && tileAdj instanceof IEnergyProvider) {
                return (float)((IEnergyProvider)tileAdj).extractEnergy(inputAdj, MathHelper.func_76141_d((float)(toPull * EnergyConfigHandler.TO_RF_RATIO)), simulate) / EnergyConfigHandler.TO_RF_RATIO;
            }
            if (isRF1Loaded && !EnergyConfigHandler.disableRFInput && tileAdj instanceof IEnergyHandler) {
                return (float)((IEnergyHandler)tileAdj).extractEnergy(inputAdj, MathHelper.func_76141_d((float)(toPull * EnergyConfigHandler.TO_RF_RATIO)), simulate) / EnergyConfigHandler.TO_RF_RATIO;
            }
        }
        return 0.0f;
    }

    public static boolean otherModCanReceive(TileEntity tileAdj, ForgeDirection inputAdj) {
        if (tileAdj instanceof TileBaseConductor || tileAdj instanceof EnergyStorageTile) {
            return false;
        }
        if (isIC2Loaded && tileAdj instanceof IEnergyAcceptor) {
            return ((IEnergyAcceptor)tileAdj).acceptsEnergyFrom(null, inputAdj);
        }
        if (isRF1Loaded && tileAdj instanceof IEnergyHandler || isRF2Loaded && tileAdj instanceof IEnergyReceiver) {
            return ((IEnergyConnection)tileAdj).canConnectEnergy(inputAdj);
        }
        return false;
    }

    public static boolean otherModCanProduce(TileEntity tileAdj, ForgeDirection side) {
        if (tileAdj instanceof TileBaseConductor || tileAdj instanceof EnergyStorageTile) {
            return false;
        }
        if (isIC2Loaded && tileAdj instanceof IEnergyEmitter) {
            return ((IEnergyEmitter)tileAdj).emitsEnergyTo(null, side);
        }
        if (isRF1Loaded && tileAdj instanceof IEnergyHandler || isRF2Loaded && tileAdj instanceof IEnergyProvider) {
            return ((IEnergyConnection)tileAdj).canConnectEnergy(side);
        }
        return false;
    }

    public static boolean initialiseIC2Methods() {
        try {
            clazzEnderIOCable = Class.forName("crazypants.enderio.conduit.TileConduitBundle");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzMFRRednetEnergyCable = Class.forName("powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzRailcraftEngine = Class.forName("mods.railcraft.common.blocks.machine.beta.TileEngine");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazzPipeTile = Class.forName("buildcraft.transport.TileGenericPipe");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isIC2Loaded) {
            GCLog.debug("Initialising IC2 methods OK");
            try {
                Class<?> clazz = Class.forName("ic2.api.energy.tile.IEnergySink");
                GCLog.debug("Found IC2 IEnergySink class OK");
                try {
                    demandedEnergyIC2 = clazz.getMethod("demandedEnergyUnits", new Class[0]);
                }
                catch (Exception e) {
                    try {
                        demandedEnergyIC2 = clazz.getMethod("getDemandedEnergy", new Class[0]);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                GCLog.debug("Set IC2 demandedEnergy method OK");
                try {
                    injectEnergyIC2 = clazz.getMethod("injectEnergyUnits", ForgeDirection.class, Double.TYPE);
                    GCLog.debug("IC2 inject 1.7.2 succeeded");
                }
                catch (Exception e) {
                    try {
                        injectEnergyIC2 = clazz.getMethod("injectEnergy", ForgeDirection.class, Double.TYPE, Double.TYPE);
                        voltageParameterIC2 = true;
                        GCLog.debug("IC2 inject 1.7.10 succeeded");
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                Class<?> clazzSource = Class.forName("ic2.api.energy.tile.IEnergySource");
                offeredEnergyIC2 = clazzSource.getMethod("getOfferedEnergy", new Class[0]);
                drawEnergyIC2 = clazzSource.getMethod("drawEnergy", Double.TYPE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (clazzPipeTile == null) {
            isBCReallyLoaded = false;
        }
        return true;
    }
}

