/*
 * Decompiled with CFR 0.152.
 */
package journeymap.shadow.org.eclipse.jetty.websocket.client;

import java.util.concurrent.Executor;
import journeymap.shadow.org.eclipse.jetty.client.HttpClient;
import journeymap.shadow.org.eclipse.jetty.io.ByteBufferPool;
import journeymap.shadow.org.eclipse.jetty.io.MappedByteBufferPool;
import journeymap.shadow.org.eclipse.jetty.util.ssl.SslContextFactory;
import journeymap.shadow.org.eclipse.jetty.util.thread.QueuedThreadPool;
import journeymap.shadow.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

class DefaultHttpClientProvider {
    DefaultHttpClientProvider() {
    }

    public static HttpClient newHttpClient(WebSocketContainerScope scope) {
        SslContextFactory sslContextFactory = null;
        Executor executor = null;
        ByteBufferPool bufferPool = null;
        if (scope != null) {
            sslContextFactory = scope.getSslContextFactory();
            executor = scope.getExecutor();
            bufferPool = scope.getBufferPool();
        }
        if (sslContextFactory == null) {
            sslContextFactory = new SslContextFactory.Client();
            sslContextFactory.setTrustAll(false);
            sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        }
        HttpClient client = new HttpClient(sslContextFactory);
        if (executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            String name = "WebSocketClient@" + client.hashCode();
            threadPool.setName(name);
            threadPool.setDaemon(true);
            executor = threadPool;
        }
        client.setExecutor(executor);
        if (bufferPool == null) {
            bufferPool = new MappedByteBufferPool();
        }
        client.setByteBufferPool(bufferPool);
        return client;
    }
}

