/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import journeymap.client.log.LogFormatter;
import journeymap.client.properties.config.Config;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.dialog.OptionsManager;
import journeymap.common.Journeymap;

public class SplashInfo {
    public ArrayList<Line> lines = new ArrayList();

    public static class Line {
        public String label;
        public String action;

        public boolean hasAction() {
            return this.action != null && this.action.trim().length() > 0;
        }

        public void invokeAction(JmUI returnUi) {
            if (!this.hasAction()) {
                return;
            }
            String[] parts = this.action.split("#");
            String className = parts[0];
            String action = null;
            if (parts.length > 0) {
                action = parts[1];
            }
            try {
                Class<?> uiClass = Class.forName("journeymap.client.ui." + className);
                if (uiClass.equals(OptionsManager.class) && action != null) {
                    Config.Category category = Config.Category.valueOf(action);
                    UIManager.getInstance().openOptionsManager(returnUi, category);
                    return;
                }
                if (action != null) {
                    String arg = parts.length == 3 ? parts[2] : null;
                    try {
                        Object ui = UIManager.getInstance().open(uiClass, returnUi);
                        if (arg == null) {
                            Method actionMethod = uiClass.getMethod(action, new Class[0]);
                            actionMethod.invoke(ui, new Object[0]);
                        } else {
                            Method actionMethod = uiClass.getMethod(action, String.class);
                            actionMethod.invoke(ui, arg);
                        }
                        return;
                    }
                    catch (Exception e) {
                        Journeymap.getLogger().warn("Couldn't perform action " + action + " on " + uiClass + ": " + e.getMessage());
                    }
                }
                UIManager.getInstance().open(uiClass, returnUi);
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Couldn't invoke action: " + action + ": " + LogFormatter.toString(t));
            }
        }
    }
}

