/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.reflection;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import ru.timeconqueror.timecore.api.reflection.ReflectionHelper;

public class UnlockedField<T> {
    private final Field field;
    private boolean finalized;

    public UnlockedField(Field field) {
        this.field = field;
        ReflectionHelper.setAccessible(field);
        this.finalized = ReflectionHelper.isFinal(field);
    }

    public T get(@Nullable Object fieldOwner) {
        try {
            return (T)this.field.get(fieldOwner);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Field getField() {
        return this.field;
    }

    public boolean isStatic() {
        return ReflectionHelper.isStatic(this.field);
    }

    public String toString() {
        return this.field.toString();
    }
}

