/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.minesweeper;

import net.minecraft.nbt.NBTTagByte;
import ru.timeconqueror.lootgames.utils.future.ICodec;

public enum Mark {
    NO_MARK(0),
    FLAG(1),
    QUESTION_MARK(2);

    public static ICodec<Mark, NBTTagByte> CODEC;
    private static final Mark[] LOOKUP;
    private final byte id;

    private Mark(byte id) {
        this.id = id;
    }

    public static Mark getNext(Mark mark) {
        return mark.id >= LOOKUP.length - 1 ? LOOKUP[0] : LOOKUP[mark.id + 1];
    }

    public Mark getNext() {
        return Mark.getNext(this);
    }

    private static Mark byID(int id) {
        if (id >= LOOKUP.length) {
            throw new IllegalArgumentException("Provided unknown id: " + id);
        }
        return LOOKUP[id];
    }

    static {
        CODEC = new Codec();
        LOOKUP = new Mark[Mark.values().length];
        Mark[] markArray = Mark.values();
        int n = markArray.length;
        for (int i = 0; i < n; ++i) {
            Mark value;
            Mark.LOOKUP[value.id] = value = markArray[i];
        }
    }

    public static class Codec
    implements ICodec<Mark, NBTTagByte> {
        @Override
        public NBTTagByte encode(Mark obj) {
            return new NBTTagByte(obj.id);
        }

        @Override
        public Mark decode(NBTTagByte nbtTagInt) {
            return Mark.byID(nbtTagInt.func_150290_f());
        }
    }
}

