/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Helpers;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import vswe.stevescarts.Items.ModItems;
import vswe.stevescarts.ModuleData.ModuleData;

public class GiftItem {
    private int chanceWeight;
    private int costPerItem;
    private ItemStack item;
    private boolean fixedSize;
    public static ArrayList<GiftItem> ChristmasList;
    public static ArrayList<GiftItem> EasterList;

    public GiftItem(ItemStack item, int costPerItem, int chanceWeight) {
        this.item = item;
        this.chanceWeight = chanceWeight;
        this.costPerItem = costPerItem;
    }

    public GiftItem(Block block, int costPerItem, int chanceWeight) {
        this(new ItemStack(block, 1), costPerItem, chanceWeight);
    }

    public GiftItem(Item item, int costPerItem, int chanceWeight) {
        this(new ItemStack(item, 1), costPerItem, chanceWeight);
    }

    public static void init() {
        ChristmasList = new ArrayList();
        ChristmasList.add(new GiftItem(new ItemStack(Blocks.field_150346_d, 32), 25, 200000));
        ChristmasList.add(new GiftItem(new ItemStack(Blocks.field_150348_b, 16), 50, 100000));
        ChristmasList.add(new GiftItem(new ItemStack(Items.field_151044_h, 8), 50, 50000));
        ChristmasList.add(new GiftItem(new ItemStack(Items.field_151137_ax, 2), 75, 22000));
        ChristmasList.add(new GiftItem(new ItemStack(Items.field_151042_j, 4), 75, 25000));
        ChristmasList.add(new GiftItem(Items.field_151043_k, 80, 17000));
        ChristmasList.add(new GiftItem(Items.field_151045_i, 250, 5000));
        GiftItem.addModuleGifts(ChristmasList);
        EasterList = new ArrayList();
        GiftItem.addModuleGifts(EasterList);
    }

    public static void addModuleGifts(ArrayList<GiftItem> gifts) {
        for (ModuleData module : ModuleData.getList().values()) {
            if (!module.getIsValid() || module.getIsLocked() || !module.getHasRecipe() || module.getCost() <= 0) continue;
            GiftItem item = new GiftItem(new ItemStack((Item)ModItems.modules, 1, (int)module.getID()), module.getCost() * 20, (int)Math.pow(151 - module.getCost(), 2.0));
            item.fixedSize = true;
            gifts.add(item);
        }
    }

    public static ArrayList<ItemStack> generateItems(Random rand, ArrayList<GiftItem> gifts, int value, int maxTries) {
        int totalChanceWeight = 0;
        for (GiftItem gift : gifts) {
            totalChanceWeight += gift.chanceWeight;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (totalChanceWeight == 0) {
            return items;
        }
        block1: for (int tries = 0; value > 0 && tries < maxTries; ++tries) {
            int chance = rand.nextInt(totalChanceWeight);
            for (GiftItem gift : gifts) {
                if (chance < gift.chanceWeight) {
                    int maxSetSize = value / gift.costPerItem;
                    if (maxSetSize * gift.item.field_77994_a > gift.item.func_77973_b().getItemStackLimit(gift.item)) {
                        maxSetSize = gift.item.func_77973_b().getItemStackLimit(gift.item) / gift.item.field_77994_a;
                    }
                    if (maxSetSize <= 0) continue block1;
                    int setSize = 1;
                    if (!gift.fixedSize) {
                        for (int i = 1; i < maxSetSize; ++i) {
                            if (!rand.nextBoolean()) continue;
                            ++setSize;
                        }
                    }
                    ItemStack item = gift.item.func_77946_l();
                    item.field_77994_a *= setSize;
                    items.add(item);
                    value -= setSize * gift.costPerItem;
                    continue block1;
                }
                chance -= gift.chanceWeight;
            }
        }
        return items;
    }
}

