/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.shape;

import gcewing.architecture.common.block.BlockShape;
import gcewing.architecture.common.shape.Generic;
import gcewing.architecture.common.shape.Model;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.Directions;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.Trans3;
import gcewing.architecture.compat.Vector3;
import gcewing.architecture.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class Banister
extends Model {
    private static final EnumFacing[] stairsFacingMap = new EnumFacing[]{Directions.F_WEST, Directions.F_EAST, Directions.F_SOUTH, Directions.F_NORTH};

    public Banister(String modelName) {
        super(modelName, (Object[])Generic.tbOffset);
    }

    @Override
    public boolean orientOnPlacement(EntityPlayer player, TileShape te, BlockPos npos, IBlockState nstate, TileEntity nte, EnumFacing otherFace, Vector3 hit) {
        if (!player.func_70093_af()) {
            int side;
            Block nblock = nstate.getBlock();
            boolean placedOnStair = false;
            int nside = -1;
            int nturn = -1;
            if (nblock instanceof BlockStairs && (otherFace == Directions.F_UP || otherFace == Directions.F_DOWN)) {
                placedOnStair = true;
                nside = Banister.stairsSide(nstate);
                nturn = Utils.turnToFace(Directions.F_SOUTH, Banister.stairsFacing(nstate));
                if (nside == 1 && (nturn & 1) == 0) {
                    nturn ^= 2;
                }
            } else if (nblock instanceof BlockShape && nte instanceof TileShape) {
                placedOnStair = true;
                nside = ((TileShape)nte).side;
                nturn = ((TileShape)nte).turn;
            }
            if (placedOnStair && (side = Utils.oppositeFacing(otherFace).ordinal()) == nside) {
                Vector3 h = Trans3.sideTurn(side, 0).ip(hit);
                double offx = te.shape.offsetXForPlacementHit(side, nturn, hit);
                te.setSide(side);
                te.setTurn(nturn & 3);
                te.setOffsetX(offx);
                return true;
            }
        }
        return super.orientOnPlacement(player, te, npos, nstate, nte, otherFace, hit);
    }

    private static EnumFacing stairsFacing(IBlockState state) {
        int meta = BlockCompatUtils.getMetaFromBlockState(state);
        return stairsFacingMap[meta & 3];
    }

    private static int stairsSide(IBlockState state) {
        int meta = BlockCompatUtils.getMetaFromBlockState(state);
        return meta >> 2 & 1;
    }

    @Override
    public double placementOffsetX() {
        return 0.375;
    }
}

