/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.gui;

import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.client.gui.ContainerSawbench;
import gcewing.architecture.client.gui.widget.GuiText;
import gcewing.architecture.client.gui.widget.Screen;
import gcewing.architecture.common.network.ChannelOutput;
import gcewing.architecture.common.shape.Shape;
import gcewing.architecture.common.shape.ShapePage;
import gcewing.architecture.common.tile.TileSawbench;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.BlockPos;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiSawbench
extends Screen {
    public static final int pageMenuLeft = 176;
    public static final int pageMenuTop = 19;
    public static final int pageMenuWidth = 58;
    public static final int pageMenuRowHeight = 10;
    public static float pageMenuScale = 1.0f;
    public static final int shapeMenuLeft = 44;
    public static final int shapeMenuTop = 23;
    public static final int shapeMenuMargin = 4;
    public static final int shapeMenuCellSize = 24;
    public static final int shapeMenuRows = 4;
    public static final int shapeMenuCols = 5;
    public static final int shapeMenuWidth = 120;
    public static final int shapeMenuHeight = 96;
    public static final int selectedShapeTitleLeft = 40;
    public static final int selectedShapeTitleTop = 128;
    public static final int selectedShapeTitleRight = 168;
    public static final int materialUsageLeft = 7;
    public static final int materialUsageTop = 82;
    public static final float shapeMenuScale = 2.0f;
    public static final float shapeMenuItemScale = 2.0f;
    public static final float shapeMenuItemUSize = 40.0f;
    public static final float shapeMenuItemVSize = 45.0f;
    public static final float shapeMenuItemWidth = 20.0f;
    public static final float shapeMenuItemHeight = 22.5f;
    public int textColor;
    public int selectedShapeBackgroundColor;
    public String localizedSawbenchName;
    public String localizedMakes;
    public String[] localizedPageNames;
    public List<String[]> localizedShapeNames;
    final TileSawbench te;

    public static GuiSawbench create(EntityPlayer player, World world, BlockPos pos) {
        TileEntity te = BlockCompatUtils.getWorldTileEntity((IBlockAccess)world, pos);
        if (te instanceof TileSawbench) {
            return new GuiSawbench(player, (TileSawbench)te);
        }
        return null;
    }

    public GuiSawbench(EntityPlayer player, TileSawbench te) {
        super(new ContainerSawbench(player, te));
        this.te = te;
        this.initLocalizationAndColor();
    }

    private void initLocalizationAndColor() {
        this.textColor = GuiText.FontColor.getColor();
        this.selectedShapeBackgroundColor = GuiText.SelectedBgColor.getColor();
        this.localizedSawbenchName = GuiText.Sawbench.getLocal();
        this.localizedMakes = GuiText.Makes.getLocal();
        this.localizedPageNames = new String[TileSawbench.pages.length];
        this.localizedShapeNames = new ArrayList<String[]>(TileSawbench.pages.length);
        for (int i = 0; i < TileSawbench.pages.length; ++i) {
            this.localizedPageNames[i] = TileSawbench.pages[i].getTitle();
            TileSawbench.pages[i].updateShapeNames();
            this.localizedShapeNames.add(TileSawbench.pages[i].getShapeNames());
        }
    }

    @Override
    protected void drawBackgroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture("gui/gui_sawbench.png", 256, 256);
        this.drawTexturedRect(0.0, 0.0, this.field_146999_f, this.field_147000_g, 0.0, 0.0);
        this.drawShapeMenu();
        this.drawShapeSelection();
        this.drawPageMenu();
        this.drawSelectedShapeTitle();
        this.field_146289_q.func_78276_b(this.localizedSawbenchName, 7, 7, this.textColor);
    }

    void drawPageMenu() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)176.0f, (float)19.0f, (float)0.0f);
        this.gSave();
        this.setColor(this.selectedShapeBackgroundColor);
        this.drawRect(0.0, this.te.selectedPage * 10, 58.0, 10.0);
        this.gRestore();
        for (int i = 0; i < this.localizedPageNames.length; ++i) {
            this.drawString(this.localizedPageNames[i], 1, 1);
            GL11.glTranslatef((float)0.0f, (float)10.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    void drawShapeMenu() {
        ShapePage page;
        this.gSave();
        GL11.glPushMatrix();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)44.0f, (float)23.0f, (float)0.0f);
        this.bindTexture("gui/shapemenu_bg.png", 256, 256);
        double w = 128.0;
        double h = 104.0;
        this.drawTexturedRect(-4.0, -4.0, w, h, 0.0, 0.0, 2.0 * w, 2.0 * h);
        int p = this.te.selectedPage;
        if (p >= 0 && p < TileSawbench.pages.length && (page = TileSawbench.pages[p]) != null) {
            Shape[] shapes = page.shapes;
            for (int i = 0; i < shapes.length; ++i) {
                Shape shape = shapes[i];
                int mrow = i / 5;
                int mcol = i % 5;
                int id = shape.id;
                int textureSheet = id / 110;
                this.bindTexture("gui/shapemenu_items_" + textureSheet + ".png", 512, 512);
                int trow = id % 110 / 10;
                int tcol = id % 110 % 10;
                this.drawTexturedRect(((double)mcol + 0.5) * 24.0 - 10.0, ((double)mrow + 0.5) * 24.0 - 11.25, 20.0, 22.5, (float)tcol * 40.0f, (float)trow * 45.0f, 40.0, 45.0);
            }
        }
        GL11.glPopMatrix();
        this.gRestore();
    }

    void drawShapeSelection() {
        int i = this.te.selectedSlots[this.te.selectedPage];
        int row = i / 5;
        int col = i % 5;
        int x = 44 + 24 * col;
        int y = 23 + 24 * row;
        this.drawTexturedRect(x, y, 24.5, 24.5, 44.0, 23.0, 49.0, 49.0);
    }

    void drawSelectedShapeTitle() {
        int pageIndex = this.te.getSelectedPageIndex();
        int shapeIndex = this.te.getSelectedShapeIndex();
        if (pageIndex != -1 && shapeIndex != -1) {
            int x = 40;
            String shapeName = this.localizedShapeNames.get(pageIndex)[shapeIndex];
            int w = this.field_146289_q.func_78256_a(shapeName);
            if (x + w > 168) {
                x = 168 - w;
            }
            this.drawString(shapeName, x, 128);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)7.0f, (float)82.0f, (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            this.drawString(String.format("%s %s %s", this.te.materialMultiple(), this.localizedMakes, this.te.resultMultiple()), 0, 0);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void mousePressed(int x, int y, int btn) {
        if (x >= 176 && y >= 19 && x < 234) {
            this.clickPageMenu(x - 176, y - 19);
        } else if (x >= 44 && y >= 23 && x < 164 && y < 119) {
            this.clickShapeMenu(x - 44, y - 23);
        } else {
            super.mousePressed(x, y, btn);
        }
    }

    void clickPageMenu(int x, int y) {
        int i = y / 10;
        if (i >= 0 && i < TileSawbench.pages.length) {
            this.sendSelectShape(i, this.te.selectedSlots[i]);
        }
    }

    void clickShapeMenu(int x, int y) {
        int row = y / 24;
        int col = x / 24;
        if (row >= 0 && row < 4 && col >= 0 && col < 5) {
            int i = row * 5 + col;
            this.sendSelectShape(this.te.selectedPage, i);
        }
    }

    protected void sendSelectShape(int page, int slot) {
        ChannelOutput data = ArchitectureCraft.channel.openServerContainer("SelectShape");
        data.writeInt(page);
        data.writeInt(slot);
        data.close();
    }
}

