/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.network.packet;

import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.client.light.HELightSMPHooks;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class HEPacketChunkUpdate
implements IMessage {
    private ByteBuf transmissionBuffer;
    private short flagsChunkY;
    private int chunkX;
    private int chunkZ;
    private ExtendedBlockStorage[] receivedChunk = null;

    public HEPacketChunkUpdate() {
    }

    public HEPacketChunkUpdate(Chunk chunk, short flagsChunkY) {
        this.transmissionBuffer = Unpooled.buffer();
        this.transmissionBuffer.writeShort((int)flagsChunkY);
        this.transmissionBuffer.writeInt(chunk.field_76635_g);
        this.transmissionBuffer.writeInt(chunk.field_76647_h);
        ExtendedBlockStorage[] blockStorages = chunk.func_76587_i();
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            if ((flagsChunkY & HEUtil.chunkYToFlag(chunkY)) <= 0) continue;
            ExtendedBlockStorage subChunk = blockStorages[chunkY];
            this.transmissionBuffer.writeInt(subChunk.field_76682_b);
            this.transmissionBuffer.writeInt(subChunk.field_76683_c);
            byte[] lsb = subChunk.func_76658_g();
            this.transmissionBuffer.writeBytes(lsb);
            NibbleArray msbArray = subChunk.func_76660_i();
            this.transmissionBuffer.writeBoolean(msbArray == null);
            if (msbArray != null) {
                this.transmissionBuffer.writeBytes(msbArray.field_76585_a);
            }
            byte[] metadata = subChunk.func_76669_j().field_76585_a;
            this.transmissionBuffer.writeBytes(metadata);
            byte[] skylight = subChunk.func_76671_l().field_76585_a;
            this.transmissionBuffer.writeBytes(skylight);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBytes(this.transmissionBuffer);
    }

    public void fromBytes(ByteBuf buf) {
        this.flagsChunkY = buf.readShort();
        this.chunkX = buf.readInt();
        this.chunkZ = buf.readInt();
        this.receivedChunk = new ExtendedBlockStorage[16];
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            if ((this.flagsChunkY & HEUtil.chunkYToFlag(chunkY)) <= 0) continue;
            ExtendedBlockStorage subChunk = new ExtendedBlockStorage(chunkY << 4, false);
            subChunk.field_76682_b = buf.readInt();
            subChunk.field_76683_c = buf.readInt();
            byte[] lsb = buf.readBytes(4096).array();
            subChunk.func_76664_a(lsb);
            if (!buf.readBoolean()) {
                byte[] msb = buf.readBytes(2048).array();
                subChunk.func_76673_a(new NibbleArray(msb, 4));
            }
            byte[] metadata = buf.readBytes(2048).array();
            subChunk.func_76668_b(new NibbleArray(metadata, 4));
            byte[] skylight = buf.readBytes(2048).array();
            subChunk.func_76666_d(new NibbleArray(skylight, 4));
            this.receivedChunk[chunkY] = subChunk;
        }
    }

    public boolean hasDataForSubChunk(int chunkY) {
        return (this.flagsChunkY & HEUtil.chunkYToFlag(chunkY)) > 0;
    }

    public static class Handler
    implements IMessageHandler<HEPacketChunkUpdate, IMessage> {
        public IMessage onMessage(HEPacketChunkUpdate message, MessageContext ctx) {
            Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_72964_e(message.chunkX, message.chunkZ);
            ExtendedBlockStorage[] chunkStorage = chunk.func_76587_i();
            for (int chunkY = 0; chunkY < 16; ++chunkY) {
                if (!message.hasDataForSubChunk(chunkY)) continue;
                if (chunkStorage[chunkY] == null) {
                    chunkStorage[chunkY] = new ExtendedBlockStorage(chunkY << 4, !chunk.field_76637_e.field_73011_w.field_76576_e);
                }
                chunkStorage[chunkY].field_76682_b = ((HEPacketChunkUpdate)message).receivedChunk[chunkY].field_76682_b;
                chunkStorage[chunkY].field_76683_c = ((HEPacketChunkUpdate)message).receivedChunk[chunkY].field_76683_c;
                chunkStorage[chunkY].func_76664_a(message.receivedChunk[chunkY].func_76658_g());
                chunkStorage[chunkY].func_76673_a(message.receivedChunk[chunkY].func_76660_i());
                chunkStorage[chunkY].func_76668_b(message.receivedChunk[chunkY].func_76669_j());
                chunkStorage[chunkY].func_76666_d(message.receivedChunk[chunkY].func_76671_l());
            }
            HELightSMPHooks.onChunkDataLoad(chunk);
            return null;
        }
    }
}

