/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.block.BlockTeleposer;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.items.TelepositionFocus;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEInventory;
import WayofTime.alchemicalWizardry.compat.IBloodMagicWailaProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class TETeleposer
extends TEInventory
implements IBloodMagicWailaProvider {
    public static final int sizeInv = 1;
    private int resultID = 0;
    private int resultDamage = 0;
    public boolean hasRedstone = false;

    public TETeleposer() {
        super(1);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.resultID = par1NBTTagCompound.func_74762_e("resultID");
        this.resultDamage = par1NBTTagCompound.func_74762_e("resultDamage");
        this.hasRedstone = par1NBTTagCompound.func_74767_n("hasRedstone");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("resultID", this.resultID);
        par1NBTTagCompound.func_74768_a("resultDamage", this.resultDamage);
        par1NBTTagCompound.func_74757_a("hasRedstone", this.hasRedstone);
    }

    @Override
    public String func_145825_b() {
        return "TETeleposer";
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void activate() {
        TETeleposer target;
        int z;
        int y;
        Item item;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack focus = this.func_70301_a(0);
        if (focus == null || !((item = focus.func_77973_b()) instanceof TelepositionFocus)) {
            return;
        }
        TelepositionFocus focusItem = (TelepositionFocus)item;
        World targetWorld = focusItem.getWorld(focus);
        if (targetWorld == null) {
            return;
        }
        int x = focusItem.xCoord(focus);
        TileEntity tileEntity = targetWorld.func_147438_o(x, y = focusItem.yCoord(focus), z = focusItem.zCoord(focus));
        if (!(tileEntity instanceof TETeleposer) || (target = (TETeleposer)tileEntity) == this) {
            return;
        }
        int damage = (int)(0.5 * Math.sqrt(Math.pow(this.field_145851_c - x, 2.0) + Math.pow(this.field_145848_d - y + 1, 2.0) + Math.pow(this.field_145849_e - z, 2.0)));
        int size = focusItem.getFocusLevel();
        List<EntityLivingBase> localEntities = this.getEntitiesInArea(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, size);
        List<EntityLivingBase> targetEntities = this.getEntitiesInArea(targetWorld, x, y, z, size);
        int entityCount = localEntities.size() + targetEntities.size();
        if (!EnergyItems.canSyphonInContainer(focus, damage * entityCount)) {
            return;
        }
        int movedBlocks = this.moveBlocks(size, targetWorld, x, y, z);
        int cost = Math.max(damage * movedBlocks + damage * entityCount, 2000);
        SoulNetworkHandler.syphonFromNetwork(focus, cost);
        if (targetWorld.equals(this.field_145850_b)) {
            this.teleportEntitiesSameWorld(localEntities, this.field_145851_c, this.field_145848_d, this.field_145849_e, x, y, z);
            this.teleportEntitiesSameWorld(targetEntities, x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            this.teleportEntitiesToOtherWorld(localEntities, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, targetWorld, x, y, z);
            this.teleportEntitiesToOtherWorld(targetEntities, targetWorld, x, y, z, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private List<EntityLivingBase> getEntitiesInArea(World world, int x, int y, int z, int size) {
        double half = (double)(size * 2 - 1) / 2.0;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - half), (double)(y + 1), (double)((double)z + 0.5 - half), (double)((double)x + 0.5 + half), (double)(y + 1 + (size * 2 - 1)), (double)((double)z + 0.5 + half));
        return world.func_72872_a(EntityLivingBase.class, box);
    }

    private int moveBlocks(int focusLevel, World targetWorld, int x, int y, int z) {
        int transportCount = 0;
        int range = focusLevel - 1;
        for (int k = 0; k <= focusLevel * 2 - 2; ++k) {
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    if (!BlockTeleposer.swapBlocks(this, this.field_145850_b, targetWorld, this.field_145851_c + i, this.field_145848_d + 1 + k, this.field_145849_e + j, x + i, y + 1 + k, z + j)) continue;
                    ++transportCount;
                }
            }
        }
        return transportCount;
    }

    private void teleportEntitiesSameWorld(List<EntityLivingBase> list, int sourceX, int sourceY, int sourceZ, int destX, int destY, int destZ) {
        String sound = "mob.endermen.portal";
        for (EntityLivingBase e : list) {
            e.func_70634_a(e.field_70165_t - (double)sourceX + (double)destX, e.field_70163_u - (double)sourceY + (double)destY, e.field_70161_v - (double)sourceZ + (double)destZ);
            e.field_70170_p.func_72908_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, sound, 1.0f, 1.0f);
        }
    }

    private void teleportEntitiesToOtherWorld(List<EntityLivingBase> list, World sourceWorld, int sourceX, int sourceY, int sourceZ, World destWorld, int destX, int destY, int destZ) {
        for (EntityLivingBase e : list) {
            SpellHelper.teleportEntityToDim(sourceWorld, destWorld.field_73011_w.field_76574_g, e.field_70165_t - (double)sourceX + (double)destX, e.field_70163_u - (double)sourceY + (double)destY, e.field_70161_v - (double)sourceZ + (double)destZ, (Entity)e);
        }
    }

    public Packet func_145844_m() {
        return NewPacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData) {
        if (intData == null) {
            return;
        }
        if (intData.length == 3) {
            for (int i = 0; i < 1; ++i) {
                ItemStack is;
                this.inv[i] = intData[2] != 0 ? (is = new ItemStack(Item.func_150899_d((int)intData[i * 3]), intData[2], intData[1])) : null;
            }
        }
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[3];
        for (ItemStack is : this.inv) {
            if (is != null) {
                sortList[0] = Item.func_150891_b((Item)is.func_77973_b());
                sortList[1] = is.func_77960_j();
                sortList[2] = is.field_77994_a;
                continue;
            }
            for (int i = 0; i < 3; ++i) {
                sortList[i] = 0;
            }
        }
        return sortList;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof TelepositionFocus;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("bm.teleposer")) {
            return;
        }
        ItemStack contained = this.func_70301_a(0);
        Item item = contained.func_77973_b();
        if (item instanceof TelepositionFocus) {
            TelepositionFocus focus = (TelepositionFocus)item;
            currenttip.add(contained.func_82833_r());
            NBTTagCompound itemTag = IBindable.getTag(contained);
            currenttip.add(StatCollector.func_74838_a((String)"tooltip.alchemy.coords") + " " + itemTag.func_74762_e("xCoord") + ", " + itemTag.func_74762_e("yCoord") + ", " + itemTag.func_74762_e("zCoord"));
            currenttip.add(StatCollector.func_74838_a((String)"tooltip.alchemy.dimension") + " " + focus.getDimensionID(contained));
        }
    }
}

