/*
 * Decompiled with CFR 0.152.
 */
package serverutils.pregenerator;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.util.misc.PregeneratorCommandInfo;
import serverutils.pregenerator.ChunkLoader;
import serverutils.pregenerator.filemanager.PregeneratorFileManager;

public class ChunkLoaderManager {
    public static final ChunkLoaderManager instance = new ChunkLoaderManager();
    private final LongArrayFIFOQueue chunksToLoad = new LongArrayFIFOQueue(1000);
    private boolean isGenerating = false;
    private int dimensionID;
    private MinecraftServer serverType;
    private int totalChunksToLoad;
    private ChunkLoader loader;
    private PregeneratorFileManager fileManager;
    private int maxChunksToFind = Integer.MAX_VALUE;

    public void initializePregenerator(PregeneratorCommandInfo commandInfo, MinecraftServer server) throws IOException {
        this.findChunksToLoadCircle(commandInfo.getRadius(), commandInfo.getXLoc(), commandInfo.getZLoc());
        this.totalChunksToLoad = this.chunksToLoad.size();
        this.dimensionID = commandInfo.getDimensionID();
        this.isGenerating = true;
        this.serverType = server;
        this.fileManager = new PregeneratorFileManager(this.serverType, commandInfo.getXLoc(), commandInfo.getZLoc(), commandInfo.getRadius(), commandInfo.getDimensionID());
        this.loader = new ChunkLoader(this.fileManager);
    }

    public boolean initializeFromPregeneratorFiles(MinecraftServer server, int dimensionToCheck) {
        try {
            Path commandFolderPath = Paths.get("saves", new String[0]).resolve(server.func_71270_I()).resolve("pregenerationFiles");
            if (Files.exists(commandFolderPath.resolve("fileCommand"), new LinkOption[0]) && Files.exists(commandFolderPath.resolve("fileIteration"), new LinkOption[0])) {
                this.fileManager = new PregeneratorFileManager(server);
                Optional<PregeneratorCommandInfo> commandInfoOptional = this.fileManager.getCommandInfo();
                if (commandInfoOptional.isPresent()) {
                    PregeneratorCommandInfo commandInfo = commandInfoOptional.get();
                    if (commandInfo.getDimensionID() != dimensionToCheck) {
                        return false;
                    }
                    this.maxChunksToFind = commandInfo.getIteration();
                    this.findChunksToLoadCircle(commandInfo.getRadius(), commandInfo.getXLoc(), commandInfo.getZLoc());
                    this.totalChunksToLoad = this.chunksToLoad.size();
                    this.dimensionID = commandInfo.getDimensionID();
                    this.serverType = server;
                    this.isGenerating = true;
                    this.loader = new ChunkLoader(this.fileManager);
                    return this.fileManager.isReady();
                }
            }
        }
        catch (IOException e) {
            this.reset(true);
            e.printStackTrace();
        }
        return false;
    }

    public boolean isGenerating() {
        return this.isGenerating;
    }

    public void findChunksToLoadCircle(int radius, double xCenter, double zCenter) {
        int chunkXCenter = (int)Math.floor(xCenter / 16.0);
        int chunkZCenter = (int)Math.floor(zCenter / 16.0);
        double decisionTracker = 1 - radius;
        int x = radius;
        int previousX = radius;
        for (int z = 0; x >= z; ++z) {
            this.addChunk(chunkXCenter + x, chunkZCenter + z);
            this.addChunk(chunkXCenter - x, chunkZCenter + z);
            if (z != x) {
                this.addChunk(chunkXCenter + z, chunkZCenter + x);
                this.addChunk(chunkXCenter + z, chunkZCenter - x);
            }
            if (z != 0) {
                this.addChunk(chunkXCenter + x, chunkZCenter - z);
                this.addChunk(chunkXCenter - x, chunkZCenter - z);
                if (z != x) {
                    this.addChunk(chunkXCenter - z, chunkZCenter + x);
                    this.addChunk(chunkXCenter - z, chunkZCenter - x);
                }
            }
            if (x != previousX) {
                this.addChunksBetween(chunkXCenter + x, chunkZCenter - z, chunkZCenter + z);
                this.addChunksBetween(chunkXCenter - x, chunkZCenter - z, chunkZCenter + z);
            }
            previousX = x;
            if (x != z) {
                this.addChunksBetween(chunkXCenter + z, chunkZCenter - x, chunkZCenter + x);
                if (z != 0) {
                    this.addChunksBetween(chunkXCenter - z, chunkZCenter - x, chunkZCenter + x);
                }
            }
            if (this.chunksToLoad.size() >= this.maxChunksToFind) break;
            if (decisionTracker < 0.0) {
                decisionTracker += (double)(2 * z + 1);
                continue;
            }
            decisionTracker += (double)(2 * (z - --x) + 1);
        }
        ServerUtilities.LOGGER.info("Found {} chunks to load", new Object[]{this.chunksToLoad.size()});
    }

    public int getChunkToLoadSize() {
        return this.chunksToLoad.size();
    }

    public int getTotalChunksToLoad() {
        return this.totalChunksToLoad;
    }

    public int getDimensionID() {
        return this.dimensionID;
    }

    public void queueChunks(int numChunksToQueue) {
        long startTime = System.nanoTime();
        for (int i = 0; i < numChunksToQueue; ++i) {
            if (this.chunksToLoad.isEmpty()) {
                this.fileManager.closeAndRemoveAllFiles();
                this.isGenerating = false;
                break;
            }
            if (System.nanoTime() - startTime >= ServerUtilitiesConfig.pregen.timeLimitNanos()) break;
            this.loader.processLoadChunk(this.serverType, this.dimensionID, this.chunksToLoad.dequeueLastLong());
        }
    }

    public String progressString() {
        int chunksLoaded = this.totalChunksToLoad - this.chunksToLoad.size();
        double percentage = (double)chunksLoaded / (double)this.totalChunksToLoad * 100.0;
        return String.format("Loaded %d chunks of a total of %d. %.1f%% done.", chunksLoaded, this.totalChunksToLoad, percentage);
    }

    public void reset(boolean hardReset) {
        this.isGenerating = false;
        this.chunksToLoad.clear();
        this.serverType = null;
        this.loader = null;
        this.dimensionID = Integer.MIN_VALUE;
        if (hardReset) {
            this.fileManager.closeAndRemoveAllFiles();
        } else {
            this.fileManager.closeAllFiles();
        }
        this.fileManager = null;
    }

    private void addChunk(int chunkX, int chunkZ) {
        if (this.chunksToLoad.size() >= this.maxChunksToFind) {
            return;
        }
        this.chunksToLoad.enqueue(CoordinatePacker.pack((int)chunkX, (int)0, (int)chunkZ));
    }

    private void addChunksBetween(int xLine, int zMin, int zMax) {
        for (int z = zMin + 1; z <= zMax - 1; ++z) {
            this.addChunk(xLine, z);
        }
    }
}

