/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import java.io.File;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.MessageViewCrashList;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageViewCrashDelete
extends MessageToServer {
    private String id;

    public MessageViewCrashDelete() {
    }

    public MessageViewCrashDelete(String s) {
        this.id = s;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.FILES;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeString(this.id);
    }

    @Override
    public void readData(DataIn data) {
        this.id = data.readString();
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        if (PermissionAPI.hasPermission((EntityPlayer)player, "admin_panel.serverutilities.crash_reports.view")) {
            File folder;
            block5: {
                folder = player.field_71133_b.func_71209_f("crash-reports");
                if (PermissionAPI.hasPermission((EntityPlayer)player, "admin_panel.serverutilities.crash_reports.delete")) {
                    try {
                        File file = new File(folder, this.id);
                        if (file.exists() && file.getParentFile().equals(folder)) {
                            file.delete();
                        }
                    }
                    catch (Exception ex) {
                        if (!ServerUtilitiesConfig.debugging.print_more_errors) break block5;
                        ex.printStackTrace();
                    }
                }
            }
            new MessageViewCrashList(folder).sendTo(player);
        }
    }
}

