/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesCommon;
import serverutils.ServerUtilitiesConfig;
import serverutils.events.SyncGamerulesEvent;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ISyncData;
import serverutils.lib.io.Bits;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.SidedUtils;
import serverutils.lib.util.StringUtils;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageSyncData
extends MessageToClient {
    private static final int LOGIN = 1;
    private static final int OP = 2;
    private static final int TRASH_CAN = 4;
    private static final int CHUNK_CLAIM = 8;
    private static final int TEAMS = 16;
    private int flags;
    private UUID universeId;
    private NBTTagCompound syncData;
    private Map<String, String> gamerules;
    private Map<String, String> modList = new HashMap<String, String>();

    public MessageSyncData() {
    }

    public MessageSyncData(boolean login, EntityPlayerMP player, ForgePlayer forgePlayer) {
        boolean op = MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(player.func_146103_bH());
        boolean trash = ServerUtilitiesConfig.commands.trash_can;
        boolean claiming = ServerUtilitiesConfig.world.chunk_claiming;
        boolean teams = ServerUtilitiesConfig.teams.disable_teams;
        this.flags = Bits.setFlag(0, 1, login);
        this.flags = Bits.setFlag(this.flags, 2, op);
        this.flags = Bits.setFlag(this.flags, 4, trash);
        this.flags = Bits.setFlag(this.flags, 8, claiming);
        this.flags = Bits.setFlag(this.flags, 16, !teams);
        this.universeId = forgePlayer.team.universe.getUUID();
        this.syncData = new NBTTagCompound();
        for (Map.Entry<String, ISyncData> entry : ServerUtilitiesCommon.SYNCED_DATA.entrySet()) {
            this.syncData.func_74782_a(entry.getKey(), (NBTBase)entry.getValue().writeSyncData(player, forgePlayer));
        }
        for (ModContainer container : Loader.instance().getActiveModList()) {
            this.modList.put(container.getModId(), container.getVersion());
        }
        this.gamerules = new HashMap<String, String>();
        new SyncGamerulesEvent(gamerule -> this.gamerules.put((String)gamerule, player.field_70170_p.func_82736_K().func_82767_a(gamerule))).post();
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeVarInt(this.flags);
        data.writeUUID(this.universeId);
        data.writeNBT(this.syncData);
        data.writeMap(this.gamerules, DataOut.STRING, DataOut.STRING);
        data.writeMap(this.modList, DataOut.STRING, DataOut.STRING);
    }

    @Override
    public void readData(DataIn data) {
        this.flags = data.readVarInt();
        this.universeId = data.readUUID();
        this.syncData = data.readNBT();
        this.gamerules = data.readMap(DataIn.STRING, DataIn.STRING);
        this.modList = data.readMap(DataIn.STRING, DataIn.STRING);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        SidedUtils.UNIVERSE_UUID_CLIENT = this.universeId;
        for (String string : this.syncData.func_150296_c()) {
            ISyncData nbt = ServerUtilitiesCommon.SYNCED_DATA.get(string);
            if (nbt == null) continue;
            nbt.readSyncData(this.syncData.func_74775_l(string));
        }
        for (Map.Entry entry : this.gamerules.entrySet()) {
            Minecraft.func_71410_x().field_71441_e.func_82736_K().func_82764_b((String)entry.getKey(), (String)entry.getValue());
        }
        if (ServerUtilitiesConfig.debugging.print_more_info && Bits.getFlag(this.flags, 1)) {
            ServerUtilities.LOGGER.info("Synced data from universe " + StringUtils.fromUUID(SidedUtils.UNIVERSE_UUID_CLIENT));
        }
        ClientUtils.is_op = Bits.getFlag(this.flags, 2);
        SidedUtils.SERVER_MODS.putAll(this.modList);
        SidedUtils.trashCan = Bits.getFlag(this.flags, 4);
        SidedUtils.chunkClaiming = Bits.getFlag(this.flags, 8);
        SidedUtils.teams = Bits.getFlag(this.flags, 16);
    }
}

