/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.misc;

import serverutils.lib.gui.GuiIcons;
import serverutils.lib.icon.Icon;
import serverutils.lib.util.IStringSerializable;
import serverutils.lib.util.misc.NameMap;

public enum EnumPrivacyLevel implements IStringSerializable
{
    PUBLIC("public"),
    PRIVATE("private"),
    TEAM("team");

    public static final EnumPrivacyLevel[] VALUES;
    public static final NameMap<EnumPrivacyLevel> NAME_MAP;
    private final String name;

    private EnumPrivacyLevel(String n2) {
        this.name = n2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        Icon icon;
        switch (this) {
            case PRIVATE: {
                icon = GuiIcons.SECURITY_PRIVATE;
                break;
            }
            case TEAM: {
                icon = GuiIcons.SECURITY_TEAM;
                break;
            }
            default: {
                icon = GuiIcons.SECURITY_PUBLIC;
            }
        }
        return icon;
    }

    public boolean isPublic() {
        return this == PUBLIC;
    }

    static {
        VALUES = EnumPrivacyLevel.values();
        NAME_MAP = NameMap.createWithBaseTranslationKey(PUBLIC, "serverutilities.privacy", VALUES);
    }
}

