/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee.inventories;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.expanded.BaubleExpandedSlots;
import baubles.common.container.InventoryBaubles;
import baubles.common.container.SlotBauble;
import java.io.File;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.ImageIcon;
import serverutils.lib.icon.PartIcon;
import serverutils.lib.util.CommonUtils;
import serverutils.lib.util.NBTUtils;

public class BaublesInventory
implements IModdedInventory {
    private static final boolean isExpanded = CommonUtils.getClassExists("baubles.api.expanded.BaubleExpandedSlots");
    private static final Icon BAUBLES_ICON;

    @Override
    @Nullable
    public IInventory loadOnlineInventory(EntityPlayerMP player) {
        return BaublesApi.getBaubles((EntityPlayer)player);
    }

    @Override
    @Nullable
    public IInventory loadOfflineInventory(ForgePlayer player) {
        File baublesFile = this.getBaublesFile(player);
        if (baublesFile == null) {
            return null;
        }
        NBTTagCompound data = NBTUtils.readNBT(baublesFile);
        if (data == null || data.func_82582_d()) {
            return null;
        }
        InventoryBaubles baubles = new InventoryBaubles(null){

            public void syncSlotToClients(int slot) {
            }
        };
        baubles.blockEvents = true;
        baubles.readNBT(data);
        return baubles;
    }

    @Override
    @NotNull
    public IInventory createInventory(EntityPlayer player, int size) {
        return new InventoryBaubles(player);
    }

    @Override
    @NotNull
    public Icon getButtonIcon() {
        return BAUBLES_ICON;
    }

    @Override
    @NotNull
    public String getButtonText() {
        return "Baubles";
    }

    @Override
    public void saveInventory(ForgePlayer player, IInventory inventory) {
        if (!player.isOnline()) {
            InventoryBaubles baubles = (InventoryBaubles)inventory;
            NBTTagCompound data = new NBTTagCompound();
            baubles.saveNBT(data);
            File baublesFile = this.getBaublesFile(player);
            if (baublesFile != null) {
                NBTUtils.writeNBTSafe(baublesFile, data);
            }
        }
    }

    @Override
    @Nullable
    public Slot getSlot(EntityPlayer player, IInventory inventory, int index, int x, int y) {
        if (isExpanded) {
            String slotType = BaubleExpandedSlots.getSlotType((int)index);
            if (slotType.equals("unknown")) {
                return null;
            }
            return new SlotBauble(inventory, BaubleExpandedSlots.getSlotType((int)index), index, x, y);
        }
        BaubleType type = index == 0 ? BaubleType.AMULET : (index == 1 || index == 2 ? BaubleType.RING : BaubleType.BELT);
        return new SlotBauble(inventory, type, index, x, y);
    }

    @Nullable
    private File getBaublesFile(ForgePlayer player) {
        File baublesFile = new File(player.team.universe.getWorldDirectory(), "playerdata/" + player.getName() + ".baub");
        if (!baublesFile.exists()) {
            baublesFile = new File(player.team.universe.getWorldDirectory(), "playerdata/" + player.getName() + ".baubback");
        }
        if (!baublesFile.exists()) {
            return null;
        }
        return baublesFile;
    }

    static {
        ImageIcon icon = isExpanded ? new ImageIcon(new ResourceLocation("baubles", "textures/gui/bauble_inventory.png")) : new ImageIcon(new ResourceLocation("baubles", "textures/gui/expanded_inventory.png"));
        BAUBLES_ICON = new PartIcon(icon, 210, 48, 10, 10, 4){

            @Override
            public void draw(int x, int y, int w, int h) {
                super.draw(x + 3, y + 3, 10, 10);
            }
        };
    }
}

